/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.issue.IssueApi;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Issues;
import org.sonarsource.sonarlint.core.serverapi.rules.RulesApi;
import org.sonarsource.sonarlint.core.serverconnection.issues.FileLevelServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.LineLevelServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.RangeLevelServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerIssue;

public class IssueDownloader {
    private final Set<Language> enabledLanguages;

    public Set<Language> getEnabledLanguages() {
        return this.enabledLanguages;
    }

    public IssueDownloader(Set<Language> enabledLanguages) {
        this.enabledLanguages = enabledLanguages;
    }

    public List<ServerIssue> downloadFromBatch(ServerApi serverApi, String key, @Nullable String branchName) {
        IssueApi issueApi = serverApi.issue();
        ArrayList<ServerIssue> result = new ArrayList<ServerIssue>();
        List<ScannerInput.ServerIssue> batchIssues = issueApi.downloadAllFromBatchIssues(key, branchName);
        for (ScannerInput.ServerIssue batchIssue : batchIssues) {
            if (RulesApi.TAINT_REPOS.contains(batchIssue.getRuleRepository()) || !batchIssue.hasPath()) continue;
            result.add(IssueDownloader.convertBatchIssue(batchIssue));
        }
        return result;
    }

    public PullResult downloadFromPull(ServerApi serverApi, String projectKey, String branchName, Optional<Instant> lastSync) {
        IssueApi issueApi = serverApi.issue();
        IssueApi.IssuesPullResult apiResult = issueApi.pullIssues(projectKey, branchName, this.enabledLanguages, lastSync.map(Instant::toEpochMilli).orElse(null));
        List<ServerIssue> changedIssues = apiResult.getIssues().stream().filter(i -> i.getMainLocation().hasFilePath()).filter(Predicate.not(Issues.IssueLite::getClosed)).map(IssueDownloader::convertLiteIssue).collect(Collectors.toList());
        Set<String> closedIssueKeys = apiResult.getIssues().stream().filter(i -> i.getMainLocation().hasFilePath()).filter(Issues.IssueLite::getClosed).map(Issues.IssueLite::getKey).collect(Collectors.toSet());
        return new PullResult(Instant.ofEpochMilli(apiResult.getTimestamp().getQueryTimestamp()), changedIssues, closedIssueKeys);
    }

    private static ServerIssue convertBatchIssue(ScannerInput.ServerIssue batchIssueFromWs) {
        String ruleKey = batchIssueFromWs.getRuleRepository() + ":" + batchIssueFromWs.getRuleKey();
        String filePath = batchIssueFromWs.getPath();
        Instant creationDate = Instant.ofEpochMilli(batchIssueFromWs.getCreationDate());
        IssueSeverity userSeverity = batchIssueFromWs.getManualSeverity() ? IssueSeverity.valueOf(batchIssueFromWs.getSeverity().name()) : null;
        RuleType ruleType = RuleType.valueOf(batchIssueFromWs.getType());
        if (batchIssueFromWs.hasLine()) {
            return new LineLevelServerIssue(batchIssueFromWs.getKey(), batchIssueFromWs.hasResolution(), ruleKey, batchIssueFromWs.getMsg(), batchIssueFromWs.getChecksum(), filePath, creationDate, userSeverity, ruleType, batchIssueFromWs.getLine());
        }
        return new FileLevelServerIssue(batchIssueFromWs.getKey(), batchIssueFromWs.hasResolution(), ruleKey, batchIssueFromWs.getMsg(), filePath, creationDate, userSeverity, ruleType);
    }

    private static ServerIssue convertLiteIssue(Issues.IssueLite liteIssueFromWs) {
        Issues.Location mainLocation = liteIssueFromWs.getMainLocation();
        String filePath = mainLocation.getFilePath();
        Instant creationDate = Instant.ofEpochMilli(liteIssueFromWs.getCreationDate());
        IssueSeverity userSeverity = liteIssueFromWs.hasUserSeverity() ? IssueSeverity.valueOf(liteIssueFromWs.getUserSeverity().name()) : null;
        RuleType ruleType = RuleType.valueOf(liteIssueFromWs.getType().name());
        if (mainLocation.hasTextRange()) {
            return new RangeLevelServerIssue(liteIssueFromWs.getKey(), liteIssueFromWs.getResolved(), liteIssueFromWs.getRuleKey(), mainLocation.getMessage(), filePath, creationDate, userSeverity, ruleType, IssueDownloader.toServerIssueTextRange(mainLocation.getTextRange()));
        }
        return new FileLevelServerIssue(liteIssueFromWs.getKey(), liteIssueFromWs.getResolved(), liteIssueFromWs.getRuleKey(), mainLocation.getMessage(), filePath, creationDate, userSeverity, ruleType);
    }

    private static TextRangeWithHash toServerIssueTextRange(Issues.TextRange textRange) {
        return new TextRangeWithHash(textRange.getStartLine(), textRange.getStartLineOffset(), textRange.getEndLine(), textRange.getEndLineOffset(), textRange.getHash());
    }

    public static class PullResult {
        private final Instant queryTimestamp;
        private final List<ServerIssue> changedIssues;
        private final Set<String> closedIssueKeys;

        public PullResult(Instant queryTimestamp, List<ServerIssue> changedIssues, Set<String> closedIssueKeys) {
            this.queryTimestamp = queryTimestamp;
            this.changedIssues = changedIssues;
            this.closedIssueKeys = closedIssueKeys;
        }

        public Instant getQueryTimestamp() {
            return this.queryTimestamp;
        }

        public List<ServerIssue> getChangedIssues() {
            return this.changedIssues;
        }

        public Set<String> getClosedIssueKeys() {
            return this.closedIssueKeys;
        }
    }
}

