/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.storage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProjectServerIssueStore;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProjectStoragePaths;
import org.sonarsource.sonarlint.core.serverconnection.storage.XodusServerIssueStore;

public class ServerIssueStoresManager {
    Map<String, ProjectServerIssueStore> serverIssueStoreByKey = new ConcurrentHashMap<String, ProjectServerIssueStore>();
    private final Path projectsStorageBaseDir;
    private final Path workDir;

    public ServerIssueStoresManager(Path projectsStorageBaseDir, Path workDir) {
        this.projectsStorageBaseDir = projectsStorageBaseDir;
        this.workDir = workDir;
    }

    public ProjectServerIssueStore get(String projectKey) {
        Path xodusBackupPath = this.projectsStorageBaseDir.resolve(ProjectStoragePaths.encodeForFs(projectKey)).resolve("issues");
        return this.serverIssueStoreByKey.computeIfAbsent(projectKey, p -> {
            try {
                return new XodusServerIssueStore(xodusBackupPath, this.workDir);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create server issue database", e);
            }
        });
    }

    public void close() {
        this.serverIssueStoreByKey.values().forEach(ProjectServerIssueStore::close);
        this.serverIssueStoreByKey.clear();
    }
}

