/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Url;

public interface IOpenIdRestClient
extends IRetrofitApi {
    @GET(value=".well-known/openid-configuration")
    public OpenIdEndpointInfo getConfiguration() throws ServiceCallException;

    @FormUrlEncoded
    @POST
    public TokenResponse validateAndObtainTokens(@Url String var1, @Field(value="grant_type") String var2, @Field(value="redirect_uri") String var3, @Field(value="client_id") String var4, @Field(value="client_secret") String var5, @Field(value="code") String var6) throws ServiceCallException;

    @GET
    public UserInfo getUserInfo(@Url String var1) throws ServiceCallException;

    public static class UserInfo {
        @JsonProperty(value="email")
        String email;
        @JsonProperty(value="given_name")
        String givenName;
        @JsonProperty(value="family_name")
        String familyName;
    }

    public static class TokenResponse {
        @JsonProperty(value="access_token")
        String accessToken;
        @JsonProperty(value="id_token")
        String idToken;
    }

    public static class OpenIdEndpointInfo {
        @JsonProperty(value="authorizationEndpoint")
        @JsonAlias(value={"authorization_endpoint"})
        private final @Nullable String authorizationEndpoint;
        @JsonProperty(value="tokenEndpoint")
        @JsonAlias(value={"token_endpoint"})
        @VisibleForTesting
        final @Nullable String tokenEndpoint;
        @JsonProperty(value="endSessionEndpoint")
        @JsonAlias(value={"end_session_endpoint"})
        private final @Nullable String endSessionEndpoint;
        @JsonProperty(value="userInfoEndpoint")
        @JsonAlias(value={"userinfo_endpoint"})
        private final @Nullable String userInfoEndpoint;

        @JsonCreator
        @VisibleForTesting
        OpenIdEndpointInfo(@JsonProperty(value="authorizationEndpoint") @JsonAlias(value={"authorization_endpoint"}) @Nullable String authorizationEndpoint, @JsonProperty(value="tokenEndpoint") @JsonAlias(value={"token_endpoint"}) @Nullable String tokenEndpoint, @JsonProperty(value="endSessionEndpoint") @JsonAlias(value={"end_session_endpoint"}) @Nullable String endSessionEndpoint, @JsonProperty(value="userInfoEndpoint") @JsonAlias(value={"userinfo_endpoint"}) @Nullable String userInfoEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            this.tokenEndpoint = tokenEndpoint;
            this.endSessionEndpoint = endSessionEndpoint;
            this.userInfoEndpoint = userInfoEndpoint;
        }
    }
}

