/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.dashboard.DashboardDescriptor;
import com.teamscale.index.dashboard.DashboardDescriptorBase;
import com.teamscale.index.dashboard.DashboardEntryWithPermissions;
import com.teamscale.index.dashboard.DashboardIndex;
import com.teamscale.index.dashboard.DashboardUtils;
import com.teamscale.index.dashboard.EDashboardDescriptorVersion;
import com.teamscale.index.dashboard.ProjectDashboardsMappingIndex;
import com.teamscale.index.user.UserDashboardFavoritesIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/dashboards")
public class DashboardService
extends ApiBase {
    private static final String PARAM_DASHBOARD_DESCRIPTOR = "dashboard";
    public static final String FILE_EXTENSION_DASHBOARD = ".tsdashboard";

    @GET
    @Path(value="{dashboardId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.DASHBOARDS, entityPathParameter="dashboardId", permissions={EBasicPermission.VIEW})
    @Operation(summary="Get dashboard", description="Retrieves the dashboard descriptor identified by given ID.", tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="No dashboard with given name found.")})
    public DashboardDescriptor getDashboard(@Parameter(description="ID of the dashboard to retrieve.") @PathParam(value="dashboardId") UUID dashboardId) throws StorageException {
        DashboardIndex dashboardIndex = this.openGlobalIndex(DashboardIndex.class);
        DashboardDescriptor dashboard = dashboardIndex.getDashboard(dashboardId);
        if (dashboard == null) {
            throw new NotFoundException("No dashboard with given name found.");
        }
        return dashboard;
    }

    @GET
    @Operation(summary="Get all dashboards", description="Retrieves all the dashboards available in the system", tags={"Dashboards"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return the dashboards visible to current user.")
    public List<DashboardEntryWithPermissions> getAllDashboards(@Parameter(description="If the dashboards should be retrieved for specific project only") @QueryParam(value="project") PublicProjectId project) throws StorageException {
        DashboardIndex dashboardIndex = this.openGlobalIndex(DashboardIndex.class);
        ProjectDashboardsMappingIndex projectDashboardMappingIndex = this.openGlobalIndex(ProjectDashboardsMappingIndex.class);
        List<DashboardDescriptor> dashboards = this.loadUserFilteredDashboards(project, dashboardIndex, projectDashboardMappingIndex);
        return DashboardEntryWithPermissions.resolvePermissions(dashboards, this.getUserDashboardFavorites(), (ServicePermissions)this.getPermissions());
    }

    @POST
    @RequiresNoPermission(description="Every logged in user is allowed to create dashboards")
    @Operation(summary="Create dashboard", description="Creates a new dashboard.", tags={"Dashboards"})
    public UUID createDashboard(@RequestBody(required=true) DashboardDescriptor dashboard) throws StorageException {
        if (dashboard.getId() != null) {
            throw new BadRequestException("The dashboard already has an ID. To update the existing dashboard use the PUT method.");
        }
        dashboard.generateId();
        return this.createOrUpdateDashboard(dashboard);
    }

    private UUID createOrUpdateDashboard(DashboardDescriptor dashboard) throws StorageException {
        DashboardIndex dashboardIndex = this.openGlobalIndex(DashboardIndex.class);
        ProjectDashboardsMappingIndex projectDashboardMappingIndex = this.openGlobalIndex(ProjectDashboardsMappingIndex.class);
        DashboardUtils.storeDashboardInIndexes((DashboardDescriptor)dashboard, (DashboardIndex)dashboardIndex, (ProjectDashboardsMappingIndex)projectDashboardMappingIndex, null);
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.DASHBOARDS, dashboard.getId().toString());
        return dashboard.getId();
    }

    @PUT
    @Path(value="{dashboardId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.DASHBOARDS, entityPathParameter="dashboardId", permissions={EBasicPermission.EDIT})
    @Operation(summary="Update dashboard", description="Updates an existing dashboard.", tags={"Dashboards"}, responses={@ApiResponse(responseCode="400", description="Dashboard ID in path and dashboard object does differ."), @ApiResponse(responseCode="404", description="No dashboard with given ID found.")})
    public void editDashboard(@Parameter(description="The ID of the dashboard to update.", required=true) @PathParam(value="dashboardId") UUID dashboardId, @RequestBody(required=true) DashboardDescriptor newValue) throws StorageException {
        DashboardDescriptor existingDashboard = this.getDashboard(dashboardId);
        this.updateElement(existingDashboard, newValue);
    }

    @POST
    @Path(value="import")
    @PublicApi(since=ETeamscaleVersion.VERSION_8_7_0)
    @RequiresNoPermission(description="Every logged in user is allowed to create dashboards")
    @Operation(summary="Create a dashboard from a dashboard export", description="Performs an import of a dashboard. Adds the uploaded descriptor to the list of dashboards/templates. The descriptor must be packaged within an JSON Teamscale Version Container.", parameters={@Parameter(name="dashboard", description="Dashboard description", content={@Content(mediaType="application/json", schema=@Schema(implementation=TeamscaleVersionContainer.class))})}, tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="No descriptor data given.")})
    @Consumes(value={"multipart/form-data"})
    public List<UUID> importDashboard(@Parameter(required=true) @ArraySchema(schema=@Schema(type="string", format="binary")) @FormDataParam(value="dashboard") List<String> unmigratedDashboardDescriptors) throws StorageException, MigrationException {
        ArrayList<UUID> importedFiles = new ArrayList<UUID>();
        List<DashboardDescriptor> migratedDashboardDescriptors = DashboardService.migrateDashboardDescriptors(unmigratedDashboardDescriptors);
        for (DashboardDescriptor descriptor : migratedDashboardDescriptors) {
            importedFiles.add(this.createDashboard(descriptor));
        }
        return importedFiles;
    }

    @PUT
    @Path(value="import")
    @PublicApi(since=ETeamscaleVersion.VERSION_8_9_8)
    @RequiresNoPermission(description="Every logged in user is allowed to create dashboards. For dashboards that already exist and should therefore be overwritten the user needs to have EDIT permissions on the dashboard.")
    @Operation(summary="Update a dashboard from a dashboard export", description="Performs an import of a dashboard. Adds the uploaded descriptor to the list of dashboards/templates. The descriptor must be packaged within an JSON Teamscale Version Container. In case the dashboard with the UUID already exists the existing one will be overridden.", parameters={@Parameter(name="dashboard", description="Dashboard description", content={@Content(mediaType="application/json", schema=@Schema(implementation=TeamscaleVersionContainer.class))})}, tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="No descriptor data given.")})
    @Consumes(value={"multipart/form-data"})
    public List<UUID> importAndReplaceDashboards(@Parameter(required=true) @ArraySchema(schema=@Schema(type="string", format="binary")) @FormDataParam(value="dashboard") List<String> dashboardDescriptors) throws StorageException, MigrationException {
        ArrayList<UUID> importedFiles = new ArrayList<UUID>();
        List<DashboardDescriptor> migratedDashboardDescriptors = DashboardService.migrateDashboardDescriptors(dashboardDescriptors);
        List<String> dashboardUUIDs = migratedDashboardDescriptors.stream().map(DashboardDescriptorBase::getId).filter(Objects::nonNull).map(UUID::toString).toList();
        this.getPermissions().checkBasicPermissionForAll(EBasicPermissionScope.DASHBOARDS, dashboardUUIDs, EBasicPermission.EDIT);
        DashboardIndex dashboardIndex = this.openGlobalIndex(DashboardIndex.class);
        for (DashboardDescriptor descriptor : migratedDashboardDescriptors) {
            UUID descriptorId = descriptor.getId();
            if (descriptorId == null) {
                importedFiles.add(this.createDashboard(descriptor));
                continue;
            }
            DashboardDescriptor dashboard = dashboardIndex.getDashboard(descriptorId);
            if (dashboard != null) {
                this.updateElement(dashboard, descriptor);
                importedFiles.add(dashboard.getId());
                continue;
            }
            importedFiles.add(this.createOrUpdateDashboard(descriptor));
        }
        return importedFiles;
    }

    private static @NonNull List<DashboardDescriptor> migrateDashboardDescriptors(List<String> unmigratedDashboardDescriptors) throws MigrationException {
        ArrayList<DashboardDescriptor> migratedDashboardDescriptors = new ArrayList<DashboardDescriptor>();
        for (String content : unmigratedDashboardDescriptors) {
            DashboardDescriptor descriptor = (DashboardDescriptor)TeamscaleVersionContainer.fromJson((String)content, null, DashboardDescriptor.class, (Enum)EDashboardDescriptorVersion.CURRENT_VERSION, (String)"dashboard descriptor");
            migratedDashboardDescriptors.add(descriptor);
        }
        return migratedDashboardDescriptors;
    }

    @DELETE
    @Path(value="{dashboardId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.DASHBOARDS, entityPathParameter="dashboardId", permissions={EBasicPermission.EDIT})
    @Operation(summary="Remove dashboard", description="Removes the dashboard descriptor identified by given ID.", tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="No dashboard with given name found.")})
    public void deleteDashboard(@Parameter(description="ID of the dashboard to retrieve.") @PathParam(value="dashboardId") UUID dashboardId) throws StorageException {
        DashboardIndex dashboardIndex = this.openGlobalIndex(DashboardIndex.class);
        DashboardDescriptor dashboard = dashboardIndex.getDashboard(dashboardId);
        if (dashboard == null) {
            throw new NotFoundException("No dashboard with given name found.");
        }
        this.deleteElement(dashboard);
    }

    @GET
    @Path(value="{dashboardId}/export")
    @RequiresBasicPermission(scope=EBasicPermissionScope.DASHBOARDS, entityPathParameter="dashboardId", permissions={EBasicPermission.VIEW})
    @Operation(summary="Get a dashboard file", description="Performs an export of a dashboard. Returns the descriptor of the dashboard as a .tsdashboard file. The dashboard must be submitted within an XML Teamscale Version Container.", tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="No dashboard template of given name found."), @ApiResponse(responseCode="400", description="Dashboard name does not contain a slash (wrong format)."), @ApiResponse(responseCode="200", description="Returns a file containing the dashboard within Teamscale Version Container.", content={@Content(mediaType="application/json", schema=@Schema(implementation=TeamscaleVersionContainer.class))})})
    public Response exportDashboard(@Parameter(description="The ID of the dashboard") @PathParam(value="dashboardId") UUID dashboardId) throws ConQATException {
        DashboardIndex dashboardIndex = this.openGlobalIndex(DashboardIndex.class);
        DashboardDescriptor descriptor = dashboardIndex.getDashboard(dashboardId);
        if (descriptor == null) {
            throw new NotFoundException("No dashboard with ID " + String.valueOf(dashboardId) + " found!");
        }
        descriptor.setId(null);
        return ResponseUtils.toFileDownload((Object)descriptor, (Enum)EDashboardDescriptorVersion.CURRENT_VERSION, (String)(descriptor.name + FILE_EXTENSION_DASHBOARD));
    }

    @POST
    @Path(value="{dashboardId}/favorite")
    @RequiresNoPermission
    @Operation(summary="Mark/Unmark a dashboard as user favorite", description="Performs an operation on the dashboard favorite list of the current user, whether to add/remove a dashboard to/from the list.", tags={"Dashboards"})
    public void markDashboardAsFavorite(@Parameter(description="Contains the name of the dashboard") @PathParam(value="dashboardId") UUID dashboardId, @Parameter(description="Whether to mark or unmark a dashboard as favorite", required=true) @QueryParam(value="setFavorite") boolean setFavorite) throws ConQATException {
        UserDashboardFavoritesIndex userDashboardFavoritesIndex = this.openGlobalIndex(UserDashboardFavoritesIndex.class);
        if (setFavorite) {
            userDashboardFavoritesIndex.setDashboardFavorite(this.getUser().getUsername(), dashboardId);
        } else {
            userDashboardFavoritesIndex.unsetDashboardFavorite(this.getUser().getUsername(), dashboardId);
        }
    }

    protected void updateElement(DashboardDescriptor existingDashboard, DashboardDescriptor newDashboard) throws StorageException {
        if (!Objects.equals(existingDashboard.getId(), newDashboard.getId())) {
            throw new BadRequestException("The ID must not be changed for a dashboard.");
        }
        newDashboard.setOwner(existingDashboard.getOwner());
        DashboardIndex dashboardIndex = this.openGlobalIndex(DashboardIndex.class);
        ProjectDashboardsMappingIndex projectDashboardMappingIndex = this.openGlobalIndex(ProjectDashboardsMappingIndex.class);
        DashboardUtils.storeDashboardInIndexes((DashboardDescriptor)newDashboard, (DashboardIndex)dashboardIndex, (ProjectDashboardsMappingIndex)projectDashboardMappingIndex, (DashboardDescriptor)existingDashboard);
    }

    protected void deleteElement(DashboardDescriptor dashboard) throws StorageException {
        DashboardIndex dashboardIndex = this.openGlobalIndex(DashboardIndex.class);
        ProjectDashboardsMappingIndex projectDashboardMappingIndex = this.openGlobalIndex(ProjectDashboardsMappingIndex.class);
        DashboardUtils.removeDashboardFromIndexes((UUID)dashboard.getId(), (DashboardIndex)dashboardIndex, (ProjectDashboardsMappingIndex)projectDashboardMappingIndex);
        this.openGlobalIndex(UserDashboardFavoritesIndex.class).unsetDashboardFavorite(this.getUser().getUsername(), dashboard.getId());
        this.getPermissions().createPermissionModifier().removeBasicRoleInstanceAssignments(EBasicPermissionScope.DASHBOARDS, dashboard.getId().toString());
    }

    private List<DashboardDescriptor> loadUserFilteredDashboards(PublicProjectId project, DashboardIndex dashboardIndex, ProjectDashboardsMappingIndex projectDashboardMappingIndex) throws StorageException {
        List<DashboardDescriptor> dashboards = new ArrayList();
        if (project != null) {
            Optional projectInfo = this.openGlobalIndex(ProjectIndex.class).tryResolveProject((IProjectId)project);
            if (projectInfo.isPresent()) {
                HashSet relevantDashboardIds = new HashSet();
                for (PublicProjectId id : ((ProjectInfo)projectInfo.get()).getPublicIds()) {
                    relevantDashboardIds.addAll(projectDashboardMappingIndex.getDashboardsForProject(id));
                }
                dashboards.addAll(dashboardIndex.getDashboards(relevantDashboardIds));
            }
        } else {
            dashboards = dashboardIndex.getAllDashboards();
        }
        dashboards.removeIf(dashboard -> !this.getPermissions().hasBasicPermission(EBasicPermissionScope.DASHBOARDS, dashboard.getId().toString(), EBasicPermission.VIEW));
        dashboards.sort(Comparator.comparing(d -> d.name).thenComparing(DashboardDescriptorBase::getId));
        return dashboards;
    }

    private Set<UUID> getUserDashboardFavorites() throws StorageException {
        return this.openGlobalIndex(UserDashboardFavoritesIndex.class).getDashboardFavorites(this.getUser().getUsername());
    }
}

