/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.backup.write.BackupWriter;
import com.teamscale.index.configuration.tools.CustomExternalMetricsConfiguration;
import com.teamscale.index.project.ExternalCodeMetricsDescriptionIndex;
import com.teamscale.index.project.ExternalMetricsDescriptionIndexBase;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.external.ExternalMetricsServiceUtils;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.ZipFileUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/external-metrics")
public class ExternalMetricsImportExportService
extends ApiBase {
    public static final String METRICS_FILE_INPUT_PARAMETER = "metrics-descriptions-import-file";
    private static final String EXPORT_FILE_NAME = "custom-metric-descriptions";

    @GET
    @Path(value="export")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_METRICS_SCHEMA})
    @Operation(summary="Downloads external metrics", description="Downloads external metrics as a ZIP file.", tags={"External Metrics"})
    @Produces(value={"application/zip"})
    public Response exportExternalMetrics() throws IOException, ConQATException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.saveMetricsAndTeamscaleVersionToZipStream(outputStream);
            byte[] content = outputStream.toByteArray();
            Response response = ResponseUtils.getResponseForAsset((String)"custom-metric-descriptions.zip", (byte[])content);
            return response;
        }
    }

    @POST
    @Path(value="import")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_METRICS_SCHEMA})
    @Operation(summary="Imports external metrics", description="Imports external metrics as a ZIP file.", tags={"External Metrics"})
    @Consumes(value={"multipart/form-data"})
    public void importExternalMetrics(@Parameter(schema=@Schema(type="string", format="binary")) @FormDataParam(value="metrics-descriptions-import-file") FormDataBodyPart externalMetrics) throws StorageException, IOException, JsonSerializationException {
        ExternalCodeMetricsDescriptionIndex externalMetricsDescriptionIndex = this.openGlobalIndex(ExternalCodeMetricsDescriptionIndex.class);
        List<MetricSchemaChangeEntry> schemaEntries = ExternalMetricsImportExportService.extractMetricDescriptions(externalMetrics);
        ExternalMetricsImportExportService.removeAlreadyExistingMetricEntries(schemaEntries, externalMetricsDescriptionIndex);
        if (!schemaEntries.isEmpty()) {
            this.validateAndUpdateMetrics(externalMetricsDescriptionIndex, schemaEntries);
        }
    }

    private void saveMetricsAndTeamscaleVersionToZipStream(OutputStream outputStream) throws ConQATException, IOException {
        ZipArchiveOutputStream findingsZipOutputStream = new ZipArchiveOutputStream(outputStream);
        byte[] metricsAsBytes = StringUtils.stringToBytes((String)JsonUtils.serializeToJSON((Object)this.openGlobalIndex(ExternalCodeMetricsDescriptionIndex.class).getAllMetrics()));
        BackupWriter.writeByteArrayToZipFile((ZipArchiveOutputStream)findingsZipOutputStream, (byte[])metricsAsBytes, (String)"custom-external-metrics/metric-entries.json");
        BackupWriter.writeVersionEntries((ZipArchiveOutputStream)findingsZipOutputStream);
        findingsZipOutputStream.close();
    }

    private static List<MetricSchemaChangeEntry> extractMetricDescriptions(FormDataBodyPart externalMetrics) throws IOException, JsonSerializationException {
        InputStream inputStream = (InputStream)externalMetrics.getValueAs(InputStream.class);
        String metricsJson = ZipFileUtils.extractEntryAsString((ZipArchiveInputStream)new ZipArchiveInputStream(inputStream), (String)"custom-external-metrics/metric-entries.json");
        return new ArrayList<MetricSchemaChangeEntry>(Arrays.asList((MetricSchemaChangeEntry[])JsonUtils.deserializeFromJson((String)metricsJson, MetricSchemaChangeEntry[].class)));
    }

    private static void removeAlreadyExistingMetricEntries(List<MetricSchemaChangeEntry> schemaEntries, ExternalCodeMetricsDescriptionIndex externalMetricsDescriptionIndex) throws StorageException {
        Map<String, MetricSchemaChangeEntry> allExistingExternalMetricsById = externalMetricsDescriptionIndex.getAllMetrics().stream().collect(Collectors.toMap(MetricSchemaChangeEntry::getMetricId, x -> x));
        schemaEntries.removeIf(entry -> {
            MetricSchemaChangeEntry existing = (MetricSchemaChangeEntry)allExistingExternalMetricsById.get(entry.getMetricId());
            return existing != null && entry.getAnalysisGroup().equals(existing.getAnalysisGroup()) && entry.getMetricDirectoryEntry().equals((Object)existing.getMetricDirectoryEntry());
        });
    }

    private void validateAndUpdateMetrics(ExternalCodeMetricsDescriptionIndex externalMetricsDescriptionIndex, List<MetricSchemaChangeEntry> schemaEntries) throws StorageException {
        ExternalMetricsServiceUtils.validateIdentifiersInMetricSchemaEntries(schemaEntries);
        ExternalMetricsServiceUtils.warnIfMetricSchemaEntryIdAlreadyInUse(schemaEntries, this.getGlobalStorageSystem());
        CustomExternalMetricsConfiguration.validateCustomExternalMetrics(schemaEntries, (ExternalMetricsDescriptionIndexBase)externalMetricsDescriptionIndex);
        externalMetricsDescriptionIndex.putMetrics(schemaEntries);
    }
}

