/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.service.findings.EFindingBlacklistOperation;
import com.teamscale.service.findings.FindingBlacklistRequestBody;
import com.teamscale.service.findings.FindingsBlacklistServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/findings/false-positive")
public class LegacyFindingsFalsePositiveService
extends FindingsBlacklistServiceBase {
    @PUT
    @PublicApi(since=ETeamscaleVersion.VERSION_5_7_0, deprecatedSince=ETeamscaleVersion.VERSION_8_5_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Mark/unmark false positive findings.", description="Marks/unmarks the given findings as false positive.", responses={@ApiResponse(responseCode="400", description="Operation is performed on unknown branch."), @ApiResponse(responseCode="400", description="Requested finding does not belong to false positive findings."), @ApiResponse(responseCode="404", description="Requested finding does not exist.")}, tags={"Findings"})
    public void markFindingsFalsePositive(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Request operation to perform (e.g. add or remove flagging information).", required=true) @QueryParam(value="operation") EFindingBlacklistOperation operation, @RequestBody(required=true) FindingBlacklistRequestBody findingBlacklistRequestBody) throws StorageException, BadRequestException, NotFoundException {
        this.performBlacklistingOperation(commit.getBranchName(), operation, findingBlacklistRequestBody, EFindingBlacklistType.FALSE_POSITIVE);
    }
}

