/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.utils.IssueUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/issues/{issueId}/hierarchy")
public class IssueHierarchyService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get issue hierarchy", description="Retrieves the respective issue hierarchy for the given issue.", tags={"Issues"}, responses={@ApiResponse(responseCode="404", description="The issue with given ID could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public IssueHierarchy getIssueHierarchy(@Parameter(description="ID of the issue to retrieve the hierarchy for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\".", schema=@Schema(type="string")) @PathParam(value="issueId") TeamscaleIssueId issueId) throws StorageException {
        IssueIndex issueIndex = this.openProjectIndex(IssueIndex.class, null);
        TeamscaleIssue originatingIssue = issueIndex.getIssue(issueId);
        if (originatingIssue == null) {
            throw new NotFoundException("The issue with ID '" + String.valueOf(issueId) + "' could not be found!");
        }
        IssueHierarchy childHierarchy = this.getIssueChildHierarchy(originatingIssue, issueIndex);
        return IssueHierarchyService.buildParentHierarchy(originatingIssue, issueIndex, childHierarchy);
    }

    private IssueHierarchy getIssueChildHierarchy(TeamscaleIssue rootIssue, IssueIndex issueIndex) throws StorageException {
        return new IssueHierarchy(rootIssue, this.getChildrenOfIssuesRecursive(rootIssue, issueIndex));
    }

    private static IssueHierarchy buildParentHierarchy(TeamscaleIssue originatingIssue, IssueIndex issueIndex, IssueHierarchy issueHierarchy) throws StorageException {
        List<TeamscaleIssue> parentHierarchy = IssueHierarchyService.getParentHierarchy(originatingIssue, issueIndex);
        if (parentHierarchy.isEmpty()) {
            return issueHierarchy;
        }
        for (TeamscaleIssue parent : parentHierarchy.subList(0, parentHierarchy.size() - 1)) {
            issueHierarchy = new IssueHierarchy(parent, List.of(issueHierarchy));
        }
        List<String> pathToIssue = parentHierarchy.stream().map(issue -> issue.getId().getInternalId()).toList();
        return new IssueHierarchy((TeamscaleIssue)CollectionUtils.getLast(parentHierarchy), List.of(issueHierarchy), pathToIssue);
    }

    private static List<TeamscaleIssue> getParentHierarchy(TeamscaleIssue issue, IssueIndex issueIndex) throws StorageException {
        ArrayList<TeamscaleIssue> parents = new ArrayList<TeamscaleIssue>();
        TeamscaleIssue current = issue;
        while (current.getParentId().isPresent()) {
            TeamscaleIssueId parentId = (TeamscaleIssueId)current.getParentId().get();
            TeamscaleIssue parent = issueIndex.getIssue(parentId);
            if (parent == null) {
                LOGGER.warn("Did not find parent issue {} of issue {}. Maybe connection problems during issue retrieval occurred?", (Object)parentId, (Object)current.getId().getExternalId());
                break;
            }
            parents.add(parent);
            current = parent;
        }
        return parents;
    }

    private List<IssueHierarchy> getChildrenOfIssuesRecursive(TeamscaleIssue issue, IssueIndex issueIndex) throws StorageException {
        LOGGER.debug("Retrieving children for issue: {}", (Object)issue);
        List childrenIssueIds = IssueUtils.determineChildIssues((TeamscaleIssueId)issue.getId(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (boolean)false);
        List childIssues = issueIndex.getIssues((Collection)childrenIssueIds);
        LOGGER.debug(() -> "-> Found child issues: " + String.join((CharSequence)", ", CollectionUtils.filterAndMap((Collection)childIssues, Objects::nonNull, child -> child.getId().getExternalId())));
        if (childIssues.isEmpty()) {
            return Collections.emptyList();
        }
        return CollectionUtils.filterAndMapWithException((Collection)childIssues, Objects::nonNull, childIssue -> new IssueHierarchy((TeamscaleIssue)childIssue, this.getChildrenOfIssuesRecursive((TeamscaleIssue)childIssue, issueIndex)));
    }

    static class IssueHierarchy {
        private static final String ID_PROPERTY = "id";
        private static final String SUBJECT_PROPERTY = "subject";
        private static final String CHILDREN_PROPERTY = "children";
        private static final String STATUS_PROPERTY = "status";
        private static final String PATH_TO_ISSUE_OF_INTEREST_PROPERTY = "pathToIssueOfInterest";
        @JsonProperty(value="id")
        final TeamscaleIssueId id;
        @JsonProperty(value="subject")
        private final String subject;
        @JsonProperty(value="status")
        private final String status;
        @JsonProperty(value="children")
        private List<IssueHierarchy> children;
        @JsonProperty(value="pathToIssueOfInterest")
        private final @Nullable List<String> pathToIssueOfInterest;

        private IssueHierarchy(TeamscaleIssue issue, List<IssueHierarchy> children) {
            this(issue, children, null);
        }

        private IssueHierarchy(TeamscaleIssue issue, List<IssueHierarchy> children, @Nullable List<String> pathToIssueOfInterest) {
            this.id = issue.getId();
            this.subject = issue.getSubject();
            this.status = issue.getStatus();
            this.children = children;
            this.pathToIssueOfInterest = pathToIssueOfInterest;
        }

        @JsonCreator
        public IssueHierarchy(@JsonProperty(value="id") TeamscaleIssueId id, @JsonProperty(value="subject") String subject, @JsonProperty(value="status") String status, @JsonProperty(value="children") List<IssueHierarchy> children, @JsonProperty(value="pathToIssueOfInterest") @Nullable List<String> pathToIssueOfInterest) {
            this.id = id;
            this.subject = subject;
            this.status = status;
            this.children = children;
            this.pathToIssueOfInterest = pathToIssueOfInterest;
        }
    }
}

