/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.core.log.service.GlobalServiceLogIndex;
import com.teamscale.core.log.service.ProjectServiceLogIndex;
import com.teamscale.core.log.worker.GlobalCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.index.external.status.ExternalAnalysisPartitionInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import com.teamscale.service.monitoring.prometheus.PrometheusMetricsUtils;
import com.teamscale.service.monitoring.prometheus.collectors.IndexCallbackMetricsProviderBase;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.function.SupplierWithException;

public class ProjectMetricsCollector
extends IndexCallbackMetricsProviderBase {
    private static final String PROJECT_LABEL_NAME = "project";
    private static final Logger LOGGER = LogManager.getLogger();

    public ProjectMetricsCollector(IndexLayer indexLayer) {
        super(indexLayer);
        this.createCollectors();
    }

    private void createCollectors() {
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_content_files")).help("Number of files on the head of the default branch")).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(projectId, projectStorageSystem) -> ProjectMetricsCollector.collectProjectContentFileCount(cb, projectId, projectStorageSystem)))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_content_loc")).help("Lines of code on the head of the default branch")).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(projectId, projectStorageSystem) -> ProjectMetricsCollector.collectProjectContentLocCount(cb, projectId, projectStorageSystem)))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_parse_log")).help("Number of parse log entries")).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> ProjectMetricsCollector.collectParseLogCount(cb, publicProjectId, projectStorageSystem)))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_worker_log")).help("Number of worker log entries")).labelNames(new String[]{PROJECT_LABEL_NAME, "level"})).callback(cb -> {
            this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> ProjectMetricsCollector.collectLogCount(cb, publicProjectId, projectStorageSystem, ProjectWorkerLogIndex.class)));
            this.collectGlobalLogCount((GaugeWithCallback.Callback)cb, (Class)GlobalWorkerLogIndex.class);
        }).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_service_log")).help("Number of service log entries")).labelNames(new String[]{PROJECT_LABEL_NAME, "level"})).callback(cb -> {
            this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> ProjectMetricsCollector.collectLogCount(cb, publicProjectId, projectStorageSystem, ProjectServiceLogIndex.class)));
            this.collectGlobalLogCount((GaugeWithCallback.Callback)cb, (Class)GlobalServiceLogIndex.class);
        }).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_event_log")).help("Number of event log entries")).labelNames(new String[]{PROJECT_LABEL_NAME, "level"})).callback(cb -> {
            this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> ProjectMetricsCollector.collectLogCount(cb, publicProjectId, projectStorageSystem, ProjectCriticalEventWorkerLogIndex.class)));
            this.collectGlobalLogCount((GaugeWithCallback.Callback)cb, (Class)GlobalCriticalEventWorkerLogIndex.class);
        }).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_commit_tree_status")).help("Number of commit tree nodes in given state")).labelNames(new String[]{PROJECT_LABEL_NAME, "state"})).callback(cb -> this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> ProjectMetricsCollector.collectCommitTreeStatus(cb, publicProjectId, projectStorageSystem)))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_connector_status")).help("Number of connectors in a malfunctioning state")).labelNames(new String[]{PROJECT_LABEL_NAME, "state"})).callback(cb -> this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> ProjectMetricsCollector.collectProjectConnectorStatus(cb, publicProjectId, projectStorageSystem)))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_analysis_status")).help("The analysis state of the project. " + PrometheusMetricsUtils.createCommentForEnumConversion(EAnalysisState.class))).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> ProjectMetricsCollector.collectProjectAnalysisStatus(cb, publicProjectId, projectStorageSystem)))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_postponed_rollbacks")).help("The count of currently postponed rollbacks in a project.")).labelNames(new String[]{PROJECT_LABEL_NAME})).callback(cb -> this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> ProjectMetricsCollector.collectProjectPostponedRollbackCount(cb, publicProjectId, projectStorageSystem)))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_paused")).help("Whether a project is paused (1) or not (0).")).labelNames(new String[]{PROJECT_LABEL_NAME, "is_voting_project"})).callback(this::collectProjectSchedulingState).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("projects")).help("Number of projects")).callback(cb -> ProjectMetricsCollector.wrapInStorageExceptionLogger(cb, (SupplierWithException<Double, StorageException>)((SupplierWithException)() -> {
            ProjectIndex projectIndex = this.indexLayer.openProjectIndex();
            return projectIndex.getAllProjectInfos().size();
        }))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("project_external_uploads")).help("Number of external uploads in a partition.")).labelNames(new String[]{PROJECT_LABEL_NAME, "partition"})).callback(cb -> this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> ProjectMetricsCollector.collectExternalUploadCount(cb, publicProjectId, projectStorageSystem)))).register();
    }

    private static void collectExternalUploadCount(GaugeWithCallback.Callback cb, PublicProjectId publicProjectId, ProjectStorageSystem projectStorageSystem) {
        try {
            List partitionInfos = (List)((ExternalAnalysisStatusIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisStatusIndex.class, null)).computeWithLock(ExternalAnalysisStatusIndex.LockedIndexAccess::getPartitionInfos);
            for (ExternalAnalysisPartitionInfo partitionInfo : partitionInfos) {
                cb.call((double)partitionInfo.getUploadCount(), new String[]{publicProjectId.projectId, partitionInfo.getName()});
            }
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve partition infos for '{}'.", (Object)publicProjectId, (Object)e);
        }
    }

    private void collectProjectSchedulingState(GaugeWithCallback.Callback cb) {
        try {
            WorkerIndex workerIndex = (WorkerIndex)this.indexLayer.openGlobalIndex(WorkerIndex.class);
            ProjectSchedulingFilter schedulingFilter = workerIndex.getSchedulingFilterAccess().get();
            ProjectIndex projectIndex = this.indexLayer.openProjectIndex();
            List allProjectInfos = projectIndex.getAllProjectInfos();
            for (ProjectInfo visibleProject : allProjectInfos) {
                boolean schedulable = schedulingFilter.isSchedulable(visibleProject.getInternalId());
                double pausedValue = schedulable ? 0.0 : 1.0;
                ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectInfo)visibleProject, (IndexLayer)this.indexLayer);
                boolean isVotingProject = VotingConnectorUtils.hasMergeRequestIntegrationEnabled((ProjectConfiguration)projectConfiguration);
                cb.call(pausedValue, new String[]{visibleProject.getPrimaryPublicId().toString(), Boolean.toString(isVotingProject)});
            }
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve project scheduling modes.", (Throwable)e);
        }
    }

    private static void collectProjectPostponedRollbackCount(GaugeWithCallback.Callback cb, PublicProjectId publicProjectId, ProjectStorageSystem projectStorageSystem) throws StorageException {
        PostponedRollbackIndex postponedRollbackIndex = (PostponedRollbackIndex)projectStorageSystem.openProjectIndex(PostponedRollbackIndex.class, null);
        int count = postponedRollbackIndex.getEntryCount();
        cb.call((double)count, new String[]{publicProjectId.toString()});
    }

    private static void collectProjectAnalysisStatus(GaugeWithCallback.Callback cb, PublicProjectId publicProjectId, ProjectStorageSystem projectStorageSystem) throws StorageException {
        ProjectAnalysisProgressIndex progressIndex = (ProjectAnalysisProgressIndex)projectStorageSystem.openProjectIndex(ProjectAnalysisProgressIndex.class, null);
        cb.call((double)progressIndex.getAnalysisState().ordinal(), new String[]{publicProjectId.toString()});
    }

    private static void collectProjectConnectorStatus(GaugeWithCallback.Callback cb, PublicProjectId publicProjectId, ProjectStorageSystem projectStorageSystem) throws StorageException {
        List connectorStatuses = ((ProjectConnectorStatusIndex)projectStorageSystem.openProjectIndex(ProjectConnectorStatusIndex.class, null)).getAllStatuses();
        Map<ProjectConnectorStatus.EConnectorStatus, Long> counts = connectorStatuses.stream().collect(Collectors.groupingBy(ProjectConnectorStatus::getStatus, Collectors.counting()));
        for (Map.Entry<ProjectConnectorStatus.EConnectorStatus, Long> statusAndCount : counts.entrySet()) {
            cb.call((double)statusAndCount.getValue().longValue(), new String[]{publicProjectId.toString(), statusAndCount.getKey().name().toLowerCase()});
        }
    }

    private static void collectCommitTreeStatus(GaugeWithCallback.Callback cb, PublicProjectId publicProjectId, ProjectStorageSystem projectStorageSystem) throws StorageException {
        EnumMap<ECommitTreeNodeState, Integer> stateCount = new EnumMap<ECommitTreeNodeState, Integer>(ECommitTreeNodeState.class);
        IndexSchema schema = projectStorageSystem.getSchema();
        for (String string : schema.getEntryNames()) {
            if (!schema.getEntry(string).getIndexClass().equals(CommitTreeIndex.class.getName())) continue;
            for (Map.Entry entry : ((CommitTreeIndex)projectStorageSystem.openProjectIndex(CommitTreeIndex.class, string, null)).getStateCount().entrySet()) {
                stateCount.merge((ECommitTreeNodeState)entry.getKey(), (Integer)entry.getValue(), Integer::sum);
            }
        }
        for (Map.Entry entry : stateCount.entrySet()) {
            cb.call((double)((Integer)entry.getValue()).intValue(), new String[]{publicProjectId.toString(), ((ECommitTreeNodeState)entry.getKey()).name().toLowerCase()});
        }
    }

    private static <T extends LogIndexBase<?, ?>> void collectLogCount(GaugeWithCallback.Callback cb, PublicProjectId publicProjectId, ProjectStorageSystem projectStorageSystem, Class<T> indexClass) throws StorageException {
        int[] frequencies = ((LogIndexBase)projectStorageSystem.openProjectIndex(indexClass, null)).getLogLevelFrequencies();
        for (LogIndexBase.EIndexLogLevel level : LogIndexBase.EIndexLogLevel.values()) {
            cb.call((double)frequencies[level.ordinal()], new String[]{publicProjectId.toString(), level.name().toLowerCase()});
        }
    }

    private <T extends LogIndexBase<?, ?>> void collectGlobalLogCount(GaugeWithCallback.Callback cb, Class<T> indexClass) {
        try {
            GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
            int[] globalFrequencies = ((LogIndexBase)globalStorageSystem.openGlobalIndex(indexClass)).getLogLevelFrequencies();
            for (LogIndexBase.EIndexLogLevel level : LogIndexBase.EIndexLogLevel.values()) {
                cb.call((double)globalFrequencies[level.ordinal()], new String[]{"__global__", level.name().toLowerCase()});
            }
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve global log count for index '{}'", indexClass, (Object)e);
        }
    }

    private static void collectParseLogCount(GaugeWithCallback.Callback cb, PublicProjectId publicProjectId, ProjectStorageSystem projectStorageSystem) throws StorageException {
        int count = ((ParseLogIndex)projectStorageSystem.openProjectIndex(ParseLogIndex.class, null)).getNumberOfEntries();
        cb.call((double)count, new String[]{publicProjectId.toString()});
    }

    private static void collectProjectContentFileCount(GaugeWithCallback.Callback cb, PublicProjectId projectId, ProjectStorageSystem projectStorageSystem) throws StorageException {
        Optional<Double> optMetricValue = ProjectMetricsCollector.getProjectMetricFromDefaultBranch(projectStorageSystem, "Files");
        optMetricValue.ifPresent(metricValue -> cb.call(metricValue.doubleValue(), new String[]{projectId.toString()}));
    }

    private static void collectProjectContentLocCount(GaugeWithCallback.Callback cb, PublicProjectId projectId, ProjectStorageSystem projectStorageSystem) throws StorageException {
        Optional<Double> optMetricValue = ProjectMetricsCollector.getProjectMetricFromDefaultBranch(projectStorageSystem, "Lines of Code");
        optMetricValue.ifPresent(metricValue -> cb.call(metricValue.doubleValue(), new String[]{projectId.toString()}));
    }

    private static Optional<Double> getProjectMetricFromDefaultBranch(ProjectStorageSystem projectStorageSystem, String metricName) throws StorageException {
        String defaultBranch = ((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
        MetricDirectorySchema schema = ((MetricSchemaIndex)projectStorageSystem.openProjectIndex(MetricSchemaIndex.class, "metric-schema", HistoryAccessOption.readHeadUnbranched())).getPublicSchema();
        MetricDirectoryEntry metrics = ((MetricDirectoryIndex)projectStorageSystem.openProjectIndex(MetricDirectoryIndex.class, "metrics-dir", HistoryAccessOption.readHead((String)defaultBranch))).getMetricDirectoryEntry("");
        if (schema == null || metrics == null) {
            return Optional.empty();
        }
        int metricLocation = schema.getValuePosition(metricName);
        if (metricLocation != -1) {
            return Optional.ofNullable(metrics.getDoubleValueWithoutNullAssert(metricLocation));
        }
        return Optional.empty();
    }
}

