/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.cache.etag.CombiningContributor;
import com.teamscale.service.framework.cache.etag.IndexLastChangeContributorBase;
import com.teamscale.service.issues.IssueIndexBaseLastUpdatedContributor;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public class SpecItemContributor
extends CombiningContributor {
    public SpecItemContributor() {
        super(List.of(new SpecItemsLastUpdatedContributor(), new SpecItemQueriesLastUpdatedContributor()));
    }

    public static class SpecItemsLastUpdatedContributor
    extends IssueIndexBaseLastUpdatedContributor<SpecItemIndex> {
        public SpecItemsLastUpdatedContributor() {
            super(SpecItemIndex.class);
        }

        @Override
        protected @NonNull List<HistoryAccessOption> getHistoryAccessOptions(ITeamscaleServiceInfo serviceInfo) throws StorageException {
            ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)serviceInfo.getProjectStorageSystem());
            if (projectConfiguration == null) {
                return Collections.emptyList();
            }
            return SpecItemIndex.getRequirementManagementConnectorBranches((ProjectConfiguration)projectConfiguration).stream().map(HistoryAccessOption::readHead).toList();
        }
    }

    public static class SpecItemQueriesLastUpdatedContributor
    extends IndexLastChangeContributorBase {
        protected IChangeTrackingIndex openIndex(ITeamscaleServiceInfo serviceInfo, ContainerRequestContext requestContext) throws Exception {
            return StoredQueryIndex.openIndex((ProjectStorageSystem)serviceInfo.getProjectStorageSystem(), (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.SPEC_ITEM);
        }
    }
}

