/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.SpecItemUtils;
import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.index.issue_reference.SpecItemReferenceBase;
import com.teamscale.index.issue_reference.SpecItemReferenceElement;
import com.teamscale.index.issue_reference.SpecItemRelationReference;
import com.teamscale.index.issue_reference.SpecItemTestExecutionReference;
import com.teamscale.index.issue_reference.SpecItemVerificationRetriever;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.requirements_tracing.model.UserResolvedSpecItem;
import com.teamscale.index.tests.PartitionAndTestExecutionResult;
import com.teamscale.index.tests.SpecItemTestReferenceIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestImplementationPathToExecutionPathIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.SortAndPaginationOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.issues.IssueFilterUtils;
import com.teamscale.service.issues.QueryServiceBase;
import com.teamscale.service.issues.TeamscaleUserAliasResolver;
import com.teamscale.service.requirements_tracing.SpecItemReferenceMapping;
import com.teamscale.service.requirements_tracing.imported_links_resolution.ImportedLinksAndTypeResolvedSpecItem;
import com.teamscale.service.requirements_tracing.imported_links_resolution.ImportedSpecItemLinksResolver;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.SetMap;

@Path(value="api/projects/{project}/spec-items")
public class SpecItemService
extends QueryServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get spec item branch", description="Get the branch where the spec item with the provided id is analysed on", tags={"Specification Items"}, responses={@ApiResponse(responseCode="200", description="Contains the spec item branch")})
    @Path(value="{id}/branch")
    public String getBranchForSpecItem(@Parameter(description="ID of the spec item to fetch the branch for", schema=@Schema(type="string")) @PathParam(value="id") TeamscaleIssueId specItemId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        return this.getSpecItemCommit(commit, specItemId.getConnectorId()).getBranchName();
    }

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get spec item", description="Gets the spec item identified by given ID", tags={"Specification Items"}, responses={@ApiResponse(responseCode="404", description="Spec item with given ID does not exist")})
    @Path(value="{id}")
    public ImportedLinksAndTypeResolvedSpecItem getSpecItem(@Parameter(description="ID of the spec item to fetch", schema=@Schema(type="string")) @PathParam(value="id") TeamscaleIssueId specItemId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        CommitDescriptor specItemCommit = this.getSpecItemCommit(commit, specItemId.getConnectorId());
        SpecItemIndex specItemIndex = this.openProjectIndex(SpecItemIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)specItemCommit));
        SpecItem specItem = (SpecItem)specItemIndex.getIssue(specItemId);
        if (specItem == null) {
            throw new NotFoundException("The spec item with ID " + String.valueOf(specItemId) + " has not been imported to Teamscale. Please check the connector configuration.");
        }
        TeamscaleUserAliasResolver resolver = new TeamscaleUserAliasResolver(UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()));
        return new ImportedLinksAndTypeResolvedSpecItem(specItem, resolver.resolveIssue((TeamscaleIssue)specItem), resolver.resolveSpecItem(specItem), ImportedSpecItemLinksResolver.resolve(arg_0 -> ((SpecItemIndex)specItemIndex).getIssues(arg_0), specItem));
    }

    private @NonNull CommitDescriptor getSpecItemCommit(UnresolvedCommitDescriptor commit, String connectorId) throws StorageException {
        CommitDescriptor specItemCommit;
        if (this.isRequirementsManagementConnectorId(connectorId)) {
            String specItemBranch = SpecItemIndex.matchRequirementsManagementConnectorIdToBranchName((String)connectorId);
            specItemCommit = new CommitDescriptor(specItemBranch, commit.getTimestamp());
        } else {
            specItemCommit = this.resolve(commit);
        }
        return specItemCommit;
    }

    @GET
    @Operation(summary="Get spec item details", description="Retrieves spec item details by their IDs.", tags={"Specification Items"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="details")
    public List<@Nullable UserResolvedSpecItem> getSpecItemDetails(@QueryParam(value="spec-item-ids") @Parameter(array=@ArraySchema(schema=@Schema(type="string"))) List<TeamscaleIssueId> specItemIds, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        ArrayList specItems = new ArrayList();
        TeamscaleUserAliasResolver resolver = new TeamscaleUserAliasResolver(UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()));
        Map<String, List<TeamscaleIssueId>> idsByConnector = specItemIds.stream().collect(Collectors.groupingBy(TeamscaleIssueId::getConnectorId));
        for (Map.Entry<String, List<TeamscaleIssueId>> entry : idsByConnector.entrySet()) {
            String connectorId = entry.getKey();
            List<TeamscaleIssueId> specItemIdsForConnector = entry.getValue();
            SpecItemIndex specItemIndex = this.openProjectIndex(SpecItemIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)this.getSpecItemCommit(commit, connectorId)));
            specItems.addAll(specItemIndex.getIssues(specItemIdsForConnector));
        }
        return UserResolvedSpecItem.of(specItems, resolver.resolveIssues(specItems), resolver.resolveSpecItems(specItems));
    }

    @GET
    @Operation(summary="Get spec item count", description="Fetches the count of spec items for the given project", tags={"Specification Items"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="count")
    public int getSpecItemCount(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        int specItemCount = 0;
        for (CommitDescriptor specItemCommit : SpecItemService.getPossibleSpecItemCommits(this.resolve(commit), this.serviceInfo.getPrimaryPublicId(), this.getIndexLayer())) {
            SpecItemIndex specItemIndex = this.openProjectIndex(SpecItemIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)specItemCommit));
            specItemCount += specItemIndex.getIssueCount();
        }
        return specItemCount;
    }

    @GET
    @Operation(summary="Get spec items", description="Retrieves the available spec items filtered by given parameters.", tags={"Specification Items"}, operationId="getSpecItemsByIdAndSorted")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<SpecItem> getSpecItemsByIdAndSorted(@BeanParam SortAndPaginationOptions parameters, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        SpecItemHistoryIndex specItemHistoryIndex = this.openProjectIndex(SpecItemHistoryIndex.class, null);
        ArrayList allSpecItems = new ArrayList();
        for (CommitDescriptor specItemCommit : SpecItemService.getPossibleSpecItemCommits(this.resolve(commit), this.serviceInfo.getPrimaryPublicId(), this.getIndexLayer())) {
            SpecItemIndex specItemIndex = this.openProjectIndex(SpecItemIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)specItemCommit));
            allSpecItems.addAll(specItemIndex.getAllIssues());
        }
        return IssueFilterUtils.applyFiltersAndPagination(allSpecItems, parameters, specItemHistoryIndex.getDescriber());
    }

    private static Set<CommitDescriptor> getPossibleSpecItemCommits(CommitDescriptor commit, PublicProjectId publicProjectId, IndexLayer indexLayer) throws StorageException {
        return SpecItemUtils.getPossibleSpecItemBranches((String)commit.getBranchName(), (PublicProjectId)publicProjectId, (IndexLayer)indexLayer).stream().map(branch -> new CommitDescriptor(branch, commit.getTimestamp())).collect(Collectors.toSet());
    }

    @GET
    @Operation(summary="Get spec item code references", description="Retrieves all spec item code references for the given spec item ID. If there is no spec item code reference, it returns an empty list.", tags={"Specification Items"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="{id}/code-references")
    public List<SpecItemCodeReference> getSpecItemCodeReferences(@Parameter(description="ID of the spec item to fetch", schema=@Schema(type="string")) @PathParam(value="id") TeamscaleIssueId specItemId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        SpecItemCodeReferenceIndex specItemCodeReferenceIndex = this.openProjectIndex(SpecItemCodeReferenceIndex.class, historyOption);
        List specItemCodeReference = specItemCodeReferenceIndex.getSpecItemCodeReferences(specItemId.getInternalId());
        if (specItemCodeReference == null) {
            return Collections.emptyList();
        }
        return specItemCodeReference;
    }

    @GET
    @Operation(summary="Get a mapping from spec items to code references and test executions", description="Returns a spec item code and test result mapping for all spec items matching the given query. If the query is empty, all known spec items are considered.", tags={"Specification Items"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="references")
    public SpecItemReferenceMapping getCodeReferencesAndTestExecutionMapping(@Parameter(description="Spec item query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        WorkItemHistoryIndexAggregation specItemHistoryIndexAggregation = WorkItemHistoryIndexAggregation.forSpecItems((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption);
        List<String> specItemIds = SpecItemService.performQueryWithErrorHandling(query, specItemHistoryIndexAggregation, historyAccessOption, StoredQueryIndex.EStoredQueryType.SPEC_ITEM, this.serviceInfo);
        Map<String, List<SpecItemCodeReference>> codeReferencesBySpecItemId = this.getCodeReferencesBySpecItemId(historyAccessOption, specItemIds);
        Map<String, ArrayList<SpecItemTestExecutionReference>> testExecutionReferencesBySpecItem = this.getTestExecutionReferencesBySpecItem(specItemIds, historyAccessOption);
        SetMap<String, PartitionAndTestExecutionResult> testResultsByTestUniformPath = this.getTestResultsByTestUniformPath(historyAccessOption, codeReferencesBySpecItemId, testExecutionReferencesBySpecItem);
        List specItems = specItemHistoryIndexAggregation.getByIds(specItemIds);
        return new SpecItemReferenceMapping(codeReferencesBySpecItemId, testExecutionReferencesBySpecItem, specItems, testResultsByTestUniformPath);
    }

    private Map<String, List<SpecItemCodeReference>> getCodeReferencesBySpecItemId(HistoryAccessOption historyAccessOption, List<String> specItemIds) throws StorageException {
        SpecItemCodeReferenceIndex codeReferenceIndex = this.openProjectIndex(SpecItemCodeReferenceIndex.class, historyAccessOption);
        return codeReferenceIndex.getSpecItemCodeReferencesBySpecItemIds(specItemIds);
    }

    private SetMap<String, PartitionAndTestExecutionResult> getTestResultsByTestUniformPath(HistoryAccessOption historyAccessOption, Map<String, List<SpecItemCodeReference>> referencesBySpecItemId, Map<String, ArrayList<SpecItemTestExecutionReference>> testExecutionReferencesBySpecItem) throws StorageException {
        List<String> testImplementationUniformPaths = referencesBySpecItemId.values().stream().flatMap(Collection::stream).map(SpecItemCodeReference::getTestImplementationUniformPath).filter(Objects::nonNull).collect(Collectors.toList());
        List<HashSet<String>> executionPaths = this.getExecutionPaths(testImplementationUniformPaths, historyAccessOption);
        HashSet executionPathsFromTestExecutionReferences = testExecutionReferencesBySpecItem.values().stream().flatMap(Collection::stream).map(SpecItemReferenceBase::getUniformPath).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        ArrayList<HashSet<String>> allExecutionPaths = new ArrayList<HashSet<String>>(executionPaths);
        allExecutionPaths.add(executionPathsFromTestExecutionReferences);
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, historyAccessOption);
        SetMap testResults = testExecutionIndex.getTestExecutionsFromAllPartitions(allExecutionPaths);
        return SpecItemService.mapTestExecutionResultsToImplementations(testImplementationUniformPaths, executionPaths, executionPathsFromTestExecutionReferences, (SetMap<String, PartitionAndTestExecutionResult>)testResults);
    }

    private Map<String, ArrayList<SpecItemTestExecutionReference>> getTestExecutionReferencesBySpecItem(List<String> specItemIds, HistoryAccessOption historyAccessOption) throws StorageException {
        SpecItemTestReferenceIndex specItemTestReferenceIndex = this.openProjectIndex(SpecItemTestReferenceIndex.class, historyAccessOption);
        Map specItemTestReferences = specItemTestReferenceIndex.getTestReferencesWithSpecItemIds(specItemIds);
        HashMap<String, ArrayList<SpecItemTestExecutionReference>> testExecutionReferences = new HashMap<String, ArrayList<SpecItemTestExecutionReference>>();
        specItemTestReferences.forEach((specItemId, partitionAndPaths) -> testExecutionReferences.put((String)specItemId, partitionAndPaths.stream().map(PartitionAndPath::getUniformPath).map(SpecItemTestExecutionReference::new).collect(Collectors.toCollection(ArrayList::new))));
        return testExecutionReferences;
    }

    @GET
    @Operation(summary="Get the spec items that the given one is verifying", tags={"Specification Items"}, operationId="getSpecItemVerifies")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="{id}/verifies")
    public Set<SpecItemReferenceElement> getSpecItemVerifies(@Parameter(description="ID of the verifying spec item", schema=@Schema(type="string")) @PathParam(value="id") TeamscaleIssueId specItemId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        SpecItemVerificationRetriever retriever = new SpecItemVerificationRetriever(this.getGlobalStorageSystem(), (ProjectStorageSystem)this.getProjectStorageSystem());
        return retriever.retrieveSpecItemsAreVerifiedBy(specItemId, this.determineHistoryOption(commit));
    }

    @GET
    @Operation(summary="Get the spec items that are verifying the given one (the given spec item is verified by...)", tags={"Specification Items"}, operationId="getVerifiedBySpecItems")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="{id}/verified-by")
    public Set<SpecItemReferenceElement> getVerifiedBySpecItems(@Parameter(description="ID of the spec item to fetch", schema=@Schema(type="string")) @PathParam(value="id") TeamscaleIssueId specItemId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        SpecItemVerificationRetriever retriever = new SpecItemVerificationRetriever(this.getGlobalStorageSystem(), (ProjectStorageSystem)this.getProjectStorageSystem());
        return retriever.retrieveSpecItemsAreVerifying(specItemId, this.determineHistoryOption(commit));
    }

    @GET
    @Operation(summary="Get the spec items that verify the queried items ", description="Retrieves all 'verified-by' references from the queried spec items to the verifying ones.", tags={"Specification Items"}, operationId="getSpecItemsVerifyingQueried")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="verify-queried-items")
    public List<SpecItemRelationReference> getSpecItemsVerifyingQueried(@Parameter(description="Spec item query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        List<TeamscaleIssueId> specItemIds = this.getQueriedSpecItemIds(query, historyOption);
        SpecItemVerificationRetriever retriever = new SpecItemVerificationRetriever(this.getGlobalStorageSystem(), (ProjectStorageSystem)this.getProjectStorageSystem());
        return retriever.retrieveSpecItemsAreVerifying(specItemIds, historyOption, false);
    }

    @GET
    @Operation(summary="Get the spec items that are verified by the queried items ", description="Retrieves all 'verifies' references from the queried spec items to the verified ones.", tags={"Specification Items"}, operationId="getSpecItemsVerifiedByQueried")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="verified-by-queried-items")
    public List<SpecItemRelationReference> getSpecItemsVerifiedByQueried(@Parameter(description="Spec item query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        List<TeamscaleIssueId> specItemIds = this.getQueriedSpecItemIds(query, historyOption);
        SpecItemVerificationRetriever retriever = new SpecItemVerificationRetriever(this.getGlobalStorageSystem(), (ProjectStorageSystem)this.getProjectStorageSystem());
        return retriever.retrieveSpecItemsAreVerifiedBy(specItemIds, historyOption, false);
    }

    private List<TeamscaleIssueId> getQueriedSpecItemIds(String query, HistoryAccessOption historyOption) throws StorageException {
        WorkItemHistoryIndexAggregation aggregation = WorkItemHistoryIndexAggregation.forSpecItems((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyOption);
        return SpecItemService.performQueryWithErrorHandling(query, aggregation, historyOption, StoredQueryIndex.EStoredQueryType.SPEC_ITEM, this.serviceInfo).stream().map(TeamscaleIssueId::fromInternalId).toList();
    }

    private static @NonNull SetMap<String, PartitionAndTestExecutionResult> mapTestExecutionResultsToImplementations(List<String> testImplementationUniformPaths, List<HashSet<String>> executionPaths, HashSet<String> executionPathsFromTestExecutionReferences, SetMap<String, PartitionAndTestExecutionResult> testResults) {
        SetMap testUniformPathToResults = new SetMap();
        for (int i = 0; i < testImplementationUniformPaths.size(); ++i) {
            String testImplementationUniformPath = testImplementationUniformPaths.get(i);
            HashSet<String> testExecutionPaths = executionPaths.get(i);
            if (testExecutionPaths == null) continue;
            for (String executionPath2 : testExecutionPaths) {
                testUniformPathToResults.addAll((Object)testImplementationUniformPath, testResults.getCollectionOrEmpty((Object)executionPath2));
            }
        }
        executionPathsFromTestExecutionReferences.forEach(executionPath -> testUniformPathToResults.addAll(executionPath, testResults.getCollectionOrEmpty(executionPath)));
        return testUniformPathToResults;
    }

    private List<HashSet<String>> getExecutionPaths(List<String> testImplementationUniformPaths, HistoryAccessOption historyAccessOption) throws StorageException {
        TestImplementationPathToExecutionPathIndex implementationPathToExecutionPathIndex = this.openProjectIndex(TestImplementationPathToExecutionPathIndex.class, historyAccessOption);
        return implementationPathToExecutionPathIndex.getExecutionPathsForImplementationPaths(testImplementationUniformPaths);
    }
}

