/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.simulink;

import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.SimulinkSignalLabelIndex;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.simulink.option.SimulinkOpaqueLibrariesOption;
import com.teamscale.index.simulink.signal_type.SimulinkOutputDataTypeIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.resource.simulink.SimulinkModelResolver;
import com.teamscale.service.resource.simulink.SimulinkOpaqueLibrariesOptionContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTruthTable;
import org.conqat.lib.simulink.ui.SimulinkBlockUIData;
import org.conqat.lib.simulink.ui.SimulinkChartUiData;
import org.conqat.lib.simulink.ui.SimulinkQualifiedNameResolver;
import org.conqat.lib.simulink.ui.SimulinkUiDataBase;
import org.conqat.lib.simulink.ui.StateflowNodeUiData;
import org.conqat.lib.simulink.ui.StateflowTransitionUiData;

@Path(value="api/projects/{project}/simulink/model/{uniformPath: .*}")
public class SimulinkModelService
extends ApiBase {
    private static final String SIMULINK_BLOCK_PREFIX = "SimulinkBlock:";
    private HistoryAccessOption historyAccessOption;

    @GET
    @Operation(summary="Get simulink model", description="Returns the content for the specified view in a simulink model (mdl and slx). The view can be the model itself, a subsystem, a Stateflow subchart, a Simulink Function node in Stateflow, ... .", tags={"Simulink"}, responses={@ApiResponse(description="The simulink model", content={@Content(schema=@Schema(implementation=SimulinkBlockData.class), mediaType="application/json")})})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, SimulinkOpaqueLibrariesOptionContributor.class})
    public SimulinkUiDataBase getSimulinkModel(@PathParam(value="uniformPath") String uniformPath, @QueryParam(value="sub-system") @Parameter(description="Specifies the sub system (or sub chart) to be returned. If not set, the UI data for the model itself will be returned.") @DefaultValue(value="") String subSystem, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        this.historyAccessOption = this.determineHistoryOption(commit);
        String subSystemQualifiedName = StringUtils.stripPrefix((String)subSystem, (String)SIMULINK_BLOCK_PREFIX);
        Optional resolvedPathOptional = ResourceServiceUtils.resolveUniqueArchitectureElementPath((String)uniformPath, (MetricsToArchitectureMetricsMappingIndex)this.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, this.historyAccessOption));
        String resolvedPath = (String)resolvedPathOptional.orElseThrow(() -> new BadRequestException("Unknown element: " + uniformPath));
        SimulinkModel model = this.loadModel(resolvedPath);
        ParameterizedElement resolvedElement = SimulinkQualifiedNameResolver.findElementInModel((SimulinkModel)model, (String)subSystemQualifiedName);
        if (resolvedElement == null) {
            return null;
        }
        if (resolvedElement instanceof SimulinkBlock) {
            SimulinkModelResolver modelResolver = new SimulinkModelResolver(super.getProjectStorageSystem(), this.historyAccessOption);
            ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
            SimulinkOpaqueLibrariesOption option = SimulinkOpaqueLibrariesOption.loadFromIndex((ProjectOptionIndex)projectOptionIndex);
            SimulinkSignalLabelIndex signalLabelIndex = this.openProjectIndex(SimulinkSignalLabelIndex.class, this.historyAccessOption);
            SimulinkPropagatedSignalLabels propagatedSignalLabels = signalLabelIndex.getSignalLabels(resolvedPath);
            SimulinkOutputDataTypeIndex simulinkOutputDataTypeIndex = this.openProjectIndex(SimulinkOutputDataTypeIndex.class, this.historyAccessOption);
            SimulinkResolvedDataTypes propagatedDataTypes = simulinkOutputDataTypeIndex.getResolvedDataTypes(resolvedPath);
            return new SimulinkBlockUIData((SimulinkBlock)resolvedElement, (SimulinkBlockUIData.IModelResolver)modelResolver, option.getOpaqueLibrariesPatternAsPredicate(), propagatedSignalLabels, propagatedDataTypes);
        }
        if (resolvedElement instanceof StateflowNodeBase) {
            return new StateflowNodeUiData((StateflowNodeBase)resolvedElement);
        }
        if (resolvedElement instanceof StateflowChart) {
            if (SimulinkModelService.elementUiNotImplemented((StateflowChart)resolvedElement)) {
                return null;
            }
            return new SimulinkChartUiData((StateflowChart)resolvedElement);
        }
        throw new BadRequestException("Could not resolve path to a Stateflow or Simulink element. Found a " + String.valueOf(resolvedElement.getClass()) + ", which can't be converted to UI display data.");
    }

    private static boolean elementUiNotImplemented(StateflowChart resolvedElement) {
        if (resolvedElement.getParent() == null) {
            return false;
        }
        if (resolvedElement.getParent() instanceof StateflowState && ((StateflowState)resolvedElement.getParent()).isMatlabFunction()) {
            return true;
        }
        return resolvedElement.getParent() instanceof StateflowTruthTable;
    }

    private SimulinkModel loadModel(String uniformPath) throws StorageException {
        BinaryElementIndex index = this.openProjectIndex(BinaryElementIndex.class, this.historyAccessOption);
        Optional model = new LazyModelLoader(index).getModelByUniformPath(uniformPath);
        if (model.isEmpty()) {
            if (index.getContent(uniformPath) != null) {
                throw new InternalServerErrorException("Model cannot be parsed: " + uniformPath);
            }
            throw new BadRequestException("Unknown element: " + uniformPath);
        }
        return (SimulinkModel)model.get();
    }

    @Schema(oneOf={SimulinkChartUiData.class, StateflowTransitionUiData.class, StateflowNodeUiData.class, SimulinkBlockUIData.class})
    public static interface SimulinkBlockData {
    }
}

