/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.support;

import com.teamscale.core.license.License;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.profiler.DetailedProfilerLog;
import com.teamscale.core.log.profiler.ShortProfilerLog;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.InstanceIdOption;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.core.support.SupportRequestIndex;
import com.teamscale.core.user.EUserActivityPeriods;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.index.admin.profiler.ProcessInformation;
import com.teamscale.index.admin.profiler.RunningProfilerInfo;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.sap.abapsystem.SapVersionIndex;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import com.teamscale.index.system_info.SystemInfoEntry;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import com.teamscale.index.system_info.SystemInfoIndex;
import com.teamscale.index.usage_data.UsageDataCollector;
import com.teamscale.index.usage_data.UserAgentsIndex;
import com.teamscale.service.admin.profiler.RunningProfilerInfoDTO;
import com.teamscale.service.admin.profiler.RunningProfilersService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.dashboard.ParallelProjectInfoLoadingUtils;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.logs.CriticalEventsGlobalLogService;
import com.teamscale.service.logs.InteractionLogGlobalLogService;
import com.teamscale.service.logs.JavascriptErrorsGlobalLogService;
import com.teamscale.service.logs.ServiceLogGlobalLogService;
import com.teamscale.service.logs.WorkerLogGlobalLogService;
import com.teamscale.service.project.ProjectsState;
import com.teamscale.service.repository.RepositoryActivitySummary;
import com.teamscale.service.repository.RepositorySummaryService;
import com.teamscale.service.system.ExecutionStatusService;
import com.teamscale.service.system.performance.debug.PerformanceAggregateDownloadService;
import com.teamscale.service.system.performance.debug.PerformanceDataDownloadServiceBase;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFileUtils;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/support-request")
public class SupportRequestService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_LOG_FILE_SIZE = 0x1400000;
    private static final int MAX_LOG_ENTRIES = 5000;
    private static final int LOG_CHAR_CHUNK_SIZE = ZipFileUtils.CHAR_CHUNK_SIZE;
    private static final int MAX_LOG_CHARS = 10 * LOG_CHAR_CHUNK_SIZE;

    @GET
    @Operation(summary="Download support request", description="Downloads the support request previously created with POST.", tags={"Support Request"}, responses={@ApiResponse(responseCode="404", description="No support request found for the current user.")})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_SUPPORT_REQUEST})
    @Produces(value={"application/zip"})
    public Response downloadSupportRequest() throws StorageException, IOException, ExecutionException, InterruptedException {
        SupportRequestIndex requestIndex = this.openRequestIndex();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeRequestZip(bos, requestIndex);
        requestIndex.removeSupportRequest(this.getUser().getUsername());
        byte[] entity = bos.toByteArray();
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)"teamscale-support-request.zip");
    }

    @POST
    @Operation(summary="Create support request", description="Creates the support request.", tags={"Support Request"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_SUPPORT_REQUEST})
    public void createSupportRequest(@RequestBody SupportRequestIndex.SupportRequestData requestData) throws StorageException {
        this.openRequestIndex().setSupportRequest(this.getUser().getUsername(), requestData);
    }

    private SupportRequestIndex openRequestIndex() throws StorageException {
        return this.openGlobalIndex(SupportRequestIndex.class);
    }

    private void writeRequestZip(OutputStream out, SupportRequestIndex requestIndex) throws IOException, StorageException, ExecutionException, InterruptedException {
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(out);){
            this.writeRequestContent(requestIndex, zos);
            this.writeWorkerLog(zos);
            this.writeServiceLog(zos);
            this.writeProfilerLogs(zos);
            this.writeInteractionLog(zos);
            this.writeEventLog(zos);
            this.writeJavaScriptErrorLog(zos);
            this.writePerformanceAggregates(zos);
            SupportRequestService.writeTeamscaleLogFiles(zos);
        }
    }

    private void writeProfilerLogs(ZipArchiveOutputStream zos) throws StorageException, IOException {
        List<RunningProfilerInfo> allProfilerRuns = RunningProfilersService.getAllProfilerRuns(this.getIndexLayer());
        for (RunningProfilerInfo run : allProfilerRuns) {
            this.writeProfilerRunInfos(zos, run);
        }
    }

    private static void writeTeamscaleLogFiles(ZipArchiveOutputStream zos) {
        for (File logFile : SupportRequestService.getLogFiles()) {
            try {
                ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)logFile.getName(), (CharSequence)SupportRequestService.readLogFileContent(logFile));
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    private static String readLogFileContent(File logFile) throws IOException {
        if (logFile.length() <= 0x1400000L) {
            return FileSystemUtils.readFileUTF8((File)logFile);
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(logFile, "r");){
            byte[] buffer = new byte[0x1400000];
            int read = randomAccessFile.read(buffer);
            String string = new String(buffer, 0, read, StandardCharsets.UTF_8) + "\n\nWARNING: file is truncated due to its size";
            return string;
        }
    }

    private static List<File> getLogFiles() {
        ArrayList<File> logFiles = new ArrayList<File>();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Collection appenders = context.getConfiguration().getAppenders().values();
        for (Appender appender : appenders) {
            File[] rolledLogFiles;
            if (appender instanceof FileAppender) {
                logFiles.add(new File(((FileAppender)appender).getFileName()));
            }
            if (!(appender instanceof RollingFileAppender)) continue;
            RollingFileAppender rollingFileAppender = (RollingFileAppender)appender;
            File logDir = new File(rollingFileAppender.getFileName()).getParentFile();
            if (logDir == null || (rolledLogFiles = logDir.listFiles((dir, name) -> name.endsWith(".log"))) == null) break;
            logFiles.addAll(Arrays.asList(rolledLogFiles));
        }
        return logFiles;
    }

    private void writeWorkerLog(ZipArchiveOutputStream zos) throws StorageException, IOException {
        SupportRequestService.writeLogZipEntry(zos, "worker-log.txt", ELogLevel.WARN, WorkerLogGlobalLogService.openWorkerLogIndexes(this.getIndexLayer()));
    }

    private void writeServiceLog(ZipArchiveOutputStream zos) throws StorageException, IOException {
        SupportRequestService.writeLogZipEntry(zos, "service-log.txt", ELogLevel.WARN, ServiceLogGlobalLogService.openServiceLogIndexes(this.getIndexLayer()));
    }

    private void writeInteractionLog(ZipArchiveOutputStream zos) throws StorageException, IOException {
        SupportRequestService.writeLogZipEntry(zos, "interaction-log.txt", ELogLevel.WARN, InteractionLogGlobalLogService.openInteractionLogIndexes(this.getIndexLayer()));
    }

    private void writeEventLog(ZipArchiveOutputStream zos) throws StorageException, IOException {
        SupportRequestService.writeLogZipEntry(zos, "event-log.txt", ELogLevel.INFO, CriticalEventsGlobalLogService.openEventLogIndexes(this.getIndexLayer()));
    }

    private void writeJavaScriptErrorLog(ZipArchiveOutputStream zos) throws StorageException, IOException {
        SupportRequestService.writeLogZipEntry(zos, "javascript-error-log.txt", ELogLevel.ERROR, JavascriptErrorsGlobalLogService.openJavascriptErrorLogIndexes(this.getIndexLayer()));
    }

    private void writePerformanceAggregates(ZipArchiveOutputStream zos) throws StorageException, IOException {
        String content = PerformanceAggregateDownloadService.createCsvContent(PerformanceDataDownloadServiceBase.openPerformanceIndexes(this.getIndexLayer()));
        ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)"performance-aggregates.csv", (CharSequence)content);
    }

    private static void writeLogZipEntry(ZipArchiveOutputStream zos, String entryName, ELogLevel minLogLevel, LogIndexesWrapper<? extends ShortLogEntryBase, ? extends DetailedLogEntryBase> index) throws StorageException, IOException {
        StreamingOutput streamingLogOutput = LogServiceUtils.getStreamingLogOutputFromIndex((LogFilteringParameters)new LogFilteringParameters(minLogLevel, 5000, Long.MAX_VALUE, 0L, 0L, null, true, false, false), (int)MAX_LOG_CHARS, index);
        zos.putArchiveEntry(new ZipArchiveEntry(entryName));
        streamingLogOutput.write((OutputStream)zos);
        zos.closeArchiveEntry();
    }

    private void writeProfilerRunInfos(ZipArchiveOutputStream zos, RunningProfilerInfo profilerInfo) throws StorageException, IOException {
        ProcessInformation process = profilerInfo.profilerInfo().processInformation();
        String entryName = String.format("coverage-profiler-%s-%s-%s.txt", process.hostname(), process.pid(), profilerInfo.id());
        zos.putArchiveEntry(new ZipArchiveEntry(entryName));
        zos.write(JsonUtils.serializeToJSON((Object)new RunningProfilerInfoDTO(profilerInfo)).getBytes(StandardCharsets.UTF_8));
        zos.write(JsonUtils.serializeToJSON((Object)profilerInfo.profilerInfo().profilerConfiguration()).getBytes(StandardCharsets.UTF_8));
        zos.write("\n\n".getBytes(StandardCharsets.UTF_8));
        LogIndexesWrapper<ShortProfilerLog, DetailedProfilerLog> logWrapper = RunningProfilersService.createLogIndexesWrapper(this.getIndexLayer(), profilerInfo.id());
        StreamingOutput streamingLogOutput = LogServiceUtils.getStreamingLogOutputFromIndex((LogFilteringParameters)new LogFilteringParameters(ELogLevel.DEBUG, 5000, 0L, Long.MAX_VALUE, 0L, null, true, false, false), (int)MAX_LOG_CHARS, logWrapper);
        streamingLogOutput.write((OutputStream)zos);
        zos.closeArchiveEntry();
    }

    private void writeRequestContent(SupportRequestIndex requestIndex, ZipArchiveOutputStream zos) throws StorageException, IOException, ExecutionException, InterruptedException {
        String user = this.getUser().getUsername();
        SupportRequestIndex.SupportRequestData requestData = requestIndex.getSupportRequest(user);
        if (requestData == null) {
            throw new InternalServerErrorException("No support request found for " + user);
        }
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        this.appendRequestData(requestData, writer);
        this.appendLicenseInfo(writer);
        this.appendContributorInfo(writer);
        this.appendSystemInfo(writer);
        this.appendUserAgentStatistics(writer);
        this.appendSapVersions(writer);
        this.appendProjectState(writer);
        SupportRequestService.appendCustomCheckInfo(writer);
        this.appendExecutionStatus(writer);
        ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)"request.txt", (CharSequence)out.toString());
    }

    private void appendContributorInfo(PrintWriter writer) throws StorageException {
        UserLastActivityIndex lastActivityIndex = this.openGlobalIndex(UserLastActivityIndex.class);
        List lastActivityTimestamps = lastActivityIndex.getLastActivityTimestamps();
        SupportRequestService.appendSection("Contributor Statistics", writer);
        writer.println();
        for (EUserActivityPeriods period : EUserActivityPeriods.values()) {
            writer.println("%-14s: %5d users, %5d committers".formatted(period.getName(), UsageDataCollector.calculateActiveUsers((TemporalAmount)period.getAmount(), (List)lastActivityTimestamps), lastActivityIndex.getNumberOfCommitters(period)));
        }
        writer.println();
    }

    private void appendProjectState(PrintWriter writer) throws StorageException, ExecutionException, InterruptedException {
        SupportRequestService.appendSection("Project state", writer);
        ProjectsState projectsState = ParallelProjectInfoLoadingUtils.getProjectsState(this.getPermissions().getVisibleProjects(), this.getParallelTaskExecutor(), this.serviceInfo.getIndexLayer());
        Map<PublicProjectId, EAnalysisState> projectStates = projectsState.getProjectStates();
        for (Map.Entry<PublicProjectId, EAnalysisState> entry : projectStates.entrySet()) {
            writer.print(String.valueOf(entry.getKey()) + ": " + String.valueOf(entry.getValue()));
            RepositoryActivitySummary repositoryActivitySummary = RepositorySummaryService.buildSummary((RepositoryLogIndex)this.getIndexLayer().openProjectIndex((IProjectId)entry.getKey(), RepositoryLogIndex.class, null), System.currentTimeMillis(), false);
            writer.println(" (commits overall=" + repositoryActivitySummary.getCommitsOverall() + ", 30days=" + repositoryActivitySummary.getCommitsLast30Days() + ", 7days=" + repositoryActivitySummary.getCommitsLast7Days() + ", 24hours=" + repositoryActivitySummary.getCommitsLast24Hours() + ")");
            List statuses = ((ProjectConnectorStatusIndex)this.getIndexLayer().openProjectIndex((IProjectId)entry.getKey(), ProjectConnectorStatusIndex.class, null)).getAllStatuses();
            for (ProjectConnectorStatus status : statuses) {
                SupportRequestService.appendConnectorStatus(writer, status);
            }
        }
    }

    private static void appendConnectorStatus(PrintWriter writer, ProjectConnectorStatus connectorStatus) {
        String lastSuccess = SupportRequestService.getSafeFormattedTime(connectorStatus.getLastSuccess());
        String lastAttempt = SupportRequestService.getSafeFormattedTime(connectorStatus.getLastAttempt());
        writer.print("   " + connectorStatus.getConnectorIdentifier() + ": " + String.valueOf(connectorStatus.getStatus()) + ", last attempt: " + lastAttempt + ", last success: " + lastSuccess);
        if (!StringUtils.isEmpty((String)connectorStatus.getErrorMessage())) {
            writer.println(", last error: " + connectorStatus.getErrorMessage());
        } else {
            writer.println();
        }
    }

    private static @NonNull String getSafeFormattedTime(@Nullable Long timestampMilliseconds) {
        if (timestampMilliseconds == null) {
            return "not available";
        }
        return DateTimeUtils.getUiFormattedDateString((long)timestampMilliseconds);
    }

    private static void appendCustomCheckInfo(PrintWriter writer) {
        SupportRequestService.appendSection("Custom Checks", writer);
        List checkInfos = CollectionUtils.sort((Collection)CheckRegistry.getInstance().getChecksInfos(), Comparator.comparing(CheckInfo::getCheckClassName));
        for (CheckInfo checkInfo : checkInfos) {
            if (checkInfo.getCheckClassName().startsWith("eu.cqse.check") || checkInfo.getCheckClassName().startsWith("org.conqat")) continue;
            writer.println(checkInfo.getCheckClassName() + " (" + checkInfo.getReadableName() + ")");
        }
    }

    private void appendRequestData(SupportRequestIndex.SupportRequestData requestData, PrintWriter writer) {
        User user = this.serviceInfo.getUser();
        writer.println("Teamscale Support Request, generated by " + String.valueOf(user) + " on " + String.valueOf(DateTimeUtils.now()));
        SupportRequestService.appendSection("Problem Description", writer);
        writer.println(requestData.problemDescription);
        writer.println();
        writer.println("User Agent: " + requestData.userAgent);
        writer.println();
    }

    private static void appendSection(String sectionName, PrintWriter writer) {
        writer.println();
        writer.println("### " + sectionName + " ###");
    }

    private void appendLicenseInfo(PrintWriter writer) throws StorageException {
        LicenseManager licenseManager = LicenseManager.getInstance();
        License license = licenseManager.getLicense();
        SupportRequestService.appendSection("License information", writer);
        if (license != null) {
            writer.println(license.getInfoString());
        } else {
            writer.println("No valid license found");
            writer.println(StringUtils.concat((Iterable)licenseManager.getErrors(), (String)StringUtils.LINE_SEPARATOR));
        }
        writer.println();
        writer.println("Instance id: " + InstanceIdOption.getId((ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class)));
        writer.println();
    }

    private void appendSystemInfo(PrintWriter writer) throws StorageException {
        SystemInfoIndex index = this.openGlobalIndex(SystemInfoIndex.class);
        Map<String, List<SystemInfoFragmentBase>> fragmentsByProcessId = index.getAllValidFragments().stream().collect(Collectors.groupingBy(SystemInfoFragmentBase::getProcessId));
        for (Map.Entry<String, List<SystemInfoFragmentBase>> entry : fragmentsByProcessId.entrySet()) {
            String processId = entry.getKey();
            SupportRequestService.appendSection("System Information for Process " + processId, writer);
            for (SystemInfoFragmentBase fragment : CollectionUtils.sort((Collection)entry.getValue(), Comparator.comparing(SystemInfoFragmentBase::getFragmentOrder).thenComparing(SystemInfoFragmentBase::getFragmentCaption))) {
                writer.println(fragment.getFragmentCaption() + ":");
                for (SystemInfoEntry systemInfoEntry : fragment.convertToKeyValuePairs()) {
                    writer.println(systemInfoEntry.getName() + ": " + String.valueOf(systemInfoEntry.getValue()));
                }
            }
        }
    }

    private void appendUserAgentStatistics(PrintWriter printWriter) throws StorageException {
        UserAgentsIndex userAgentsIndex = this.openGlobalIndex(UserAgentsIndex.class);
        SupportRequestService.appendSection("User Agents", printWriter);
        CounterSet userAgentFrequency = userAgentsIndex.getUserAgentFrequency();
        for (String userAgent : userAgentFrequency.getKeys()) {
            printWriter.println(userAgent + " (" + userAgentFrequency.getValue((Object)userAgent) + " users)");
        }
    }

    private void appendSapVersions(PrintWriter printWriter) throws StorageException {
        Map versionsByConnection = this.openGlobalIndex(SapVersionIndex.class).getVersionsByConnectionId();
        if (!versionsByConnection.isEmpty()) {
            SupportRequestService.appendSection("SAP Versions", printWriter);
            versionsByConnection.forEach((connectionId, version) -> printWriter.println(connectionId + ": " + version.getAbapVersion() + " / " + version.getConnectorVersion()));
        }
    }

    private void appendExecutionStatus(PrintWriter writer) throws StorageException {
        WorkerIndex workerIndex = this.openGlobalIndex(WorkerIndex.class);
        SupportRequestService.appendSection("Job Queue", writer);
        List visibleProjects = this.getPermissions().getVisibleProjects();
        List<ExecutionStatusService.JobDescriptorDto> jobs = ExecutionStatusService.extractJobQueue(this.serviceInfo, visibleProjects);
        if (jobs.isEmpty()) {
            writer.println("<empty>");
        } else {
            writer.println(StringUtils.concat(jobs, (String)StringUtils.LINE_SEPARATOR));
        }
        SupportRequestService.appendSection("Worker Cluster Status", writer);
        List clusterStatusList = workerIndex.getWorkerClusterStatusAccess().listAll();
        for (WorkerClusterStatus clusterStatus : clusterStatusList) {
            writer.println("Cluster " + clusterStatus.getProcessId());
            for (WorkerClusterStatus.WorkerThreadStatus threadStatus : clusterStatus.getThreadStatuses()) {
                writer.print(threadStatus.getWorkerId() + ": ");
                writer.print(threadStatus.getTaskName());
                if (!StringUtils.isEmpty((String)threadStatus.getTaskName())) {
                    writer.println(", running for " + (System.currentTimeMillis() - threadStatus.getStartTimestamp()) / 1000L + "s");
                    continue;
                }
                writer.println();
            }
        }
        SupportRequestService.appendStackTracesOfAllThreads(writer);
    }

    public static void appendStackTracesOfAllThreads(PrintWriter writer) {
        SupportRequestService.appendSection("Threads", writer);
        SupportRequestService.appendStackTracesOfThreads(writer, thread -> true);
    }

    public static void appendStackTracesOfThreads(PrintWriter writer, Predicate<Thread> predicate) {
        SupportRequestService.appendStackTracesOfThreads(writer::print, writer::println, predicate, writer::println);
    }

    public static void appendStackTracesOfThreads(Consumer<String> print, Consumer<String> println, Predicate<Thread> predicate, Consumer<Thread> headerConsumer) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> stackTraceEntry : stackTraces.entrySet()) {
            if (!predicate.test(stackTraceEntry.getKey())) continue;
            headerConsumer.accept(stackTraceEntry.getKey());
            for (StackTraceElement stackTraceElement : stackTraceEntry.getValue()) {
                print.accept("  ");
                println.accept(stackTraceElement.toString());
            }
            println.accept("");
        }
    }
}

