/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import com.teamscale.core.runtime.impl.worker.WorkerThread;
import com.teamscale.index.repository.RepositoryLogEntry;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

class WorkerStatus {
    @JsonProperty(value="workerId")
    private final String workerId;
    @JsonProperty(value="jobRuntime")
    private final long jobRuntime;
    @JsonProperty(value="primaryProjectId")
    private final @Nullable PublicProjectId projectId;
    @JsonProperty(value="taskName")
    private final @Nullable String taskName;
    @JsonProperty(value="commit")
    private final @Nullable CommitDescriptor commit;
    @JsonProperty(value="repositoryIdentifier")
    private @Nullable String repositoryIdentifier;
    @JsonProperty(value="revision")
    private @Nullable String revision;
    @JsonProperty(value="additionalWorkers")
    private final int additionalWorkers;
    @JsonProperty(value="supportedWorker")
    private final @Nullable String supportedWorker;
    @JsonProperty(value="cancelable")
    private final boolean cancelable;
    @JsonProperty(value="runStatus")
    private final EWorkerRunStatus runStatus;

    public WorkerStatus(WorkerClusterStatus.WorkerThreadStatus threadStatus, int additionalWorkers) {
        this(threadStatus, threadStatus.getWorkerId(), threadStatus.getStartTimestamp(), null, additionalWorkers);
    }

    public WorkerStatus(WorkerClusterStatus.WorkerThreadStatus threadStatus, WorkerClusterStatus.WorkerThreadStatus supportedThreadStatus) {
        this(supportedThreadStatus, threadStatus.getWorkerId(), threadStatus.getStartTimestamp(), threadStatus.getSupportedWorker(), 0);
    }

    private WorkerStatus(WorkerClusterStatus.WorkerThreadStatus threadStatus, String workerId, long startTimestamp, @Nullable String supportedWorker, int additionalWorkers) {
        this.workerId = workerId;
        this.jobRuntime = System.currentTimeMillis() - startTimestamp;
        this.projectId = threadStatus.getProjectId();
        this.taskName = threadStatus.getTaskName() == null || WorkerThread.isAdministrativePhaseName((String)threadStatus.getTaskName()) ? null : threadStatus.getTaskName();
        this.commit = threadStatus.getCommit();
        this.supportedWorker = supportedWorker;
        this.additionalWorkers = additionalWorkers;
        this.runStatus = EWorkerRunStatus.of(threadStatus.getRunState());
        this.cancelable = threadStatus.isCancelable();
    }

    public @Nullable PublicProjectId getProjectId() {
        return this.projectId;
    }

    public @Nullable CommitDescriptor getCommit() {
        return this.commit;
    }

    public void appendRevisionData(RepositoryLogEntry logEntry) {
        this.repositoryIdentifier = logEntry.getRepositoryIdentifier();
        this.revision = logEntry.getRevision();
    }

    @ExportToTypeScript
    public static enum EWorkerRunStatus {
        IDLE,
        RUNNING,
        CANCELED,
        ABORTED;


        public static EWorkerRunStatus of(WorkerClusterStatus.WorkerThreadStatus.EWorkerThreadRunStatus workerRunStatus) {
            return switch (workerRunStatus) {
                default -> throw new MatchException(null, null);
                case WorkerClusterStatus.WorkerThreadStatus.EWorkerThreadRunStatus.IDLE -> IDLE;
                case WorkerClusterStatus.WorkerThreadStatus.EWorkerThreadRunStatus.RUNNING -> RUNNING;
                case WorkerClusterStatus.WorkerThreadStatus.EWorkerThreadRunStatus.CANCELED -> CANCELED;
                case WorkerClusterStatus.WorkerThreadStatus.EWorkerThreadRunStatus.ABORTED -> ABORTED;
            };
        }
    }
}

