/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.health;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.system.health.ESystemHealthMetric;
import com.teamscale.service.system.health.SystemHealthUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/health-metrics")
public class SystemHealthMetricService
extends ApiBase {
    private static final NumberFormat METRIC_VALUE_FORMAT = NumberFormat.getNumberInstance(Locale.US);

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    @Operation(summary="Get system health metrics.", description="Returns health metrics in plaintext format.", tags={"Monitoring"})
    @Produces(value={"text/plain", "application/json"})
    public String getSystemHealthMetrics(@Parameter(description="One or more enabled metrics. If none is given, all metrics are activated.") @QueryParam(value="metrics") List<String> metricParameters, @Parameter(description="A prefix to be prepended to the metrics.") @QueryParam(value="prefix") @DefaultValue(value="") String prefix) throws StorageException {
        StringBuilder resultBuilder = new StringBuilder();
        int now = (int)(System.currentTimeMillis() / 1000L);
        List<ESystemHealthMetric> metrics = SystemHealthUtils.determineChecksOrMetrics(metricParameters, ESystemHealthMetric.class);
        for (ESystemHealthMetric metric : metrics) {
            List<ESystemHealthMetric.SystemHealthMetricEntry> result = metric.reportMetrics(this.serviceInfo);
            result.forEach(entry -> resultBuilder.append(SystemHealthMetricService.buildName(prefix, metric.getNamePrefix(), entry.name())).append(" ").append(METRIC_VALUE_FORMAT.format(entry.value())).append(" ").append(now).append("\n"));
        }
        return resultBuilder.toString();
    }

    private static String buildName(String mainPrefix, String metricPrefix, String metricName) {
        StringBuilder result = new StringBuilder(mainPrefix);
        if (result.length() > 0 && !metricPrefix.isEmpty()) {
            result.append(".");
        }
        result.append(metricPrefix);
        if (result.length() > 0 && !metricName.isEmpty()) {
            result.append(".");
        }
        result.append(metricName);
        return result.toString();
    }

    static {
        METRIC_VALUE_FORMAT.setMinimumFractionDigits(0);
        METRIC_VALUE_FORMAT.setMaximumFractionDigits(2);
        METRIC_VALUE_FORMAT.setGroupingUsed(false);
    }
}

