/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.index.resource.VirtualCodePathUtils;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.MethodIdMap;
import com.teamscale.index.testimpact.PartitionedTestSet;
import com.teamscale.index.testimpact.TiaPartitionsQueryParams;
import com.teamscale.index.testimpact.TiaRequestOptions;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.testimpact.TiaDataRetrieverOptions;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ImpactedTestUtils {
    public static Map<MethodId, PartitionedTestSet> computeMethodToTestsMapping(CoverageUnitToMethodsMapIndex testsToMethodsMapIndex, TiaPartitionsQueryParams partitionInfo, Collection<MethodId> methodIds) throws StorageException {
        if (partitionInfo.isAllPartitions()) {
            return testsToMethodsMapIndex.getTestsCoveringMethods(methodIds);
        }
        return testsToMethodsMapIndex.getTestsCoveringMethods(methodIds, (Collection)partitionInfo.getPartitions());
    }

    public static List<MethodId> computeMethodIds(MethodIdIndex methodIdIndex, Collection<MethodLocation> methodLocations) throws StorageException {
        MethodIdMap allMappings = methodIdIndex.getAllMappingsFor(methodLocations.stream().map(MethodLocation::getUniformPath).distinct().collect(Collectors.toList()));
        return CollectionUtils.map(methodLocations, arg_0 -> ((MethodIdMap)allMappings).getMethodId(arg_0));
    }

    public static List<PartitionAndPath> getAllTestsCovering(TiaRequestOptions tiaRequestOptions, ITeamscaleServiceInfo serviceInfo, Set<MethodId> methodsToTest) throws StorageException {
        TiaDataRetrieverOptions tiaDataRetrieverOptions = TiaDataRetrieverOptions.create(tiaRequestOptions, serviceInfo.getInternalId(), serviceInfo.getUser(), serviceInfo.getIndexLayer());
        ImpactedTestUtils.ensureCommitIsProcessed(serviceInfo.getProjectStorageSystem(), tiaDataRetrieverOptions);
        methodsToTest = ImpactedTestUtils.filterMethodsContainedInPath(tiaDataRetrieverOptions, serviceInfo.getProjectStorageSystem(), methodsToTest);
        HistoryAccessOption historyAccessOptions = ImpactedTestUtils.getEndCommitAccessOptions(tiaDataRetrieverOptions);
        HashSet allPartitions = new HashSet(((TestExecutionIndex)serviceInfo.getProjectStorageSystem().openProjectIndex(TestExecutionIndex.class, historyAccessOptions)).getPartitions());
        return ((CoverageUnitToMethodsMapIndex)serviceInfo.getProjectStorageSystem().openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOptions)).getAllCoveringTestsForMethodsMerged(allPartitions, methodsToTest).stream().toList();
    }

    static @NonNull Set<MethodId> filterMethodsContainedInPath(TiaDataRetrieverOptions tiaDataRetrieverOptions, CommitResolvingStorageSystem projectStorageSystem, Set<MethodId> methodsToTest) throws StorageException {
        Predicate containmentChecker = VirtualCodePathUtils.includedInResolvedTree((UniformPath)tiaDataRetrieverOptions.tiaRequestOptions().getCoveringPath(), (ProjectStorageSystem)projectStorageSystem, (HistoryAccessOption)ImpactedTestUtils.getEndCommitAccessOptions(tiaDataRetrieverOptions));
        methodsToTest = methodsToTest.stream().filter(method -> method != null && containmentChecker.test(method.getUniformPath())).collect(Collectors.toSet());
        return methodsToTest;
    }

    private static HistoryAccessOption getEndCommitAccessOptions(TiaDataRetrieverOptions tiaDataRetrieverOptions) {
        return HistoryAccessOption.readCommit((CommitDescriptor)tiaDataRetrieverOptions.getEndCommit());
    }

    static void ensureCommitIsProcessed(CommitResolvingStorageSystem projectStorageSystem, TiaDataRetrieverOptions tiaDataRetrieverOptions) throws StorageException {
        if (tiaDataRetrieverOptions.tiaRequestOptions().isEnsureProcessed() && !ImpactedTestUtils.isRequestedCommitProcessed(projectStorageSystem, tiaDataRetrieverOptions.getEndCommit())) {
            throw new WebApplicationException("The requested commit " + String.valueOf(tiaDataRetrieverOptions.getEndCommit()) + " has not been processed yet!", Response.Status.PRECONDITION_FAILED);
        }
    }

    private static boolean isRequestedCommitProcessed(CommitResolvingStorageSystem projectStorageSystem, CommitDescriptor commit) throws StorageException {
        BranchAnalysisStateIndex branchAnalysisStateIndex = (BranchAnalysisStateIndex)projectStorageSystem.openProjectIndex(BranchAnalysisStateIndex.class, null);
        AnalysisState analysisState = branchAnalysisStateIndex.getAnalysisState(commit.getBranchName());
        return analysisState != null && analysisState.getTimestamp() >= commit.getTimestamp();
    }

    private ImpactedTestUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

