/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.user.User;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresUserPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.user.UserBatchOperation;
import com.teamscale.service.user.UserService;
import com.teamscale.service.user.UserWithActivity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

public interface IUserServiceApi {
    @GET
    @RequiresNoPermission(description="Only users visible to the user are returned in the get all queries.")
    @Operation(summary="Get all users", description="Returns a list of all users.", tags={"Users"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    public List<UserWithActivity> getAllUsers() throws StorageException;

    @GET
    @Path(value="{user}")
    @Operation(summary="Get user", description="Returns information about one user.", tags={"Users"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    @RequiresUserPermission(value={EBasicPermission.VIEW})
    public User getUser(@PathParam(value="user") String var1) throws StorageException;

    @PUT
    @Path(value="{user}")
    @Operation(summary="Update user", description="Creates a new user or overwrites an existing one.", tags={"Users"})
    @RequiresNoPermission(description="The user needs either CREATE_USER or EDIT user permissions to create or edit the user and EDIT permissions on the groups the user is added to or removed from.")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    public void putUser(@PathParam(value="user") String var1, @RequestBody(required=true) UserService.UserData var2) throws StorageException;

    @DELETE
    @Path(value="{users}")
    @Operation(summary="Delete users", description="Deletes the given users.", tags={"Users"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    @RequiresUserPermission(value={EBasicPermission.DELETE}, entityPathParameter="users")
    public String deleteUser(@Parameter(description="The user names to delete. May be either a single user name or a comma separated list of names.", schema=@Schema(type="string")) @PathParam(value="users") List<String> var1) throws StorageException;

    @POST
    @Operation(summary="Edit users", description="Performs given user operation.", tags={"Users"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_5_1)
    @RequiresNoPermission(description="Needs delete permission.")
    public String deleteUsers(UserBatchOperation var1) throws StorageException;

    @GET
    @Path(value="find")
    @Operation(summary="Get user autocompletion suggestions", description="Gets autocompletion suggestions based on the input", tags={"Users"})
    @RequiresNoPermission
    public Collection<String> autocompleteUserName(@QueryParam(value="token") String var1, @QueryParam(value="regex") boolean var2, @QueryParam(value="max_matches") @DefaultValue(value="50") int var3) throws StorageException;
}

