/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.github.GitHubAppUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.dto.GitHubUser;
import com.teamscale.core.authenticate.github.dto.Installation;
import com.teamscale.core.authenticate.github.dto.InstallationRepository;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.github.index.LongKey;
import com.teamscale.core.authenticate.github.index.OAuthTokenIndex;
import com.teamscale.core.authenticate.github.index.OrgOrUserInstallationsKey;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.GitHubChangeRetriever;
import com.teamscale.index.repository.git.github.GitHubCheckRunCleanupOption;
import com.teamscale.index.repository.git.github.GitHubCrossRepositoryMergeRequestHandler;
import com.teamscale.index.repository.git.github.GitHubMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.github.GitHubPendingCheckRunReporter;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.in_progress_reporting.AnalysisInProgressReporter;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.webhook.GitManagementPlatformWebhookServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/github/web-hook")
public class GitHubApplicationWebHookService
extends GitManagementPlatformWebhookServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern URL_PATTERN = Pattern.compile("\"html_url\":\"(https://[-a-zA-Z0-9+.]*\\.[-a-zA-Z]*/)");
    private static final String EDITED_PULL_REQUEST_ACTION = "edited";
    private static final String SYNCHRONIZE_PULL_REQUEST_ACTION = "synchronize";
    private static final String CLOSED_PULL_REQUEST_ACTION = "closed";
    private static final String OPENED_PULL_REQUEST_ACTION = "opened";
    private static final String REOPENED_PULL_REQUEST_ACTION = "reopened";
    private static final Set<String> RELEVANT_PULL_REQUEST_ACTIONS = CollectionUtils.asHashSet((Object[])new String[]{"synchronize", "edited", "opened", "reopened", "closed"});
    private static final Set<String> RELEVANT_CHECK_RUN_ACTIONS = Set.of("completed", "created", "rerequested");
    public static final String GITHUB_EVENT_HEADER_NAME = "X-GitHub-Event";
    public static final String GITHUB_SHA256_SIGNATURE_HEADER_NAME = "X-Hub-Signature-256";
    public static final String GITHUB_INSTALLATION_TARGET_ID_HEADER_NAME = "X-GitHub-Hook-Installation-Target-ID";

    public GitHubApplicationWebHookService() {
        super(GitHubChangeRetriever.class);
    }

    @POST
    @Operation(summary="Handles the incoming requests from the GitHub app.", description="Handles the incoming requests from the GitHub app and processes the request body depending on the event. The events which are handled by the service are: 'ping', 'installation', 'installation_repositories', 'pull_request', 'push', 'github_app_authorization', 'check_run' and 'status'.", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response processWebHook(@HeaderParam(value="X-GitHub-Event") String event, @HeaderParam(value="X-Hub-Signature-256") String signature, @HeaderParam(value="X-GitHub-Hook-Installation-Target-ID") String appId, @RequestBody byte[] requestBody) throws StorageException {
        String queryContent = StringUtils.bytesToString((byte[])requestBody);
        LOGGER.debug("Received a web hook request from GitHub with event \"{}\" and payload: {}", (Object)event, (Object)queryContent);
        if (StringUtils.isEmpty((String)event)) {
            throw new BadRequestException("Event header missing!");
        }
        if (event.equals("ping")) {
            return Response.ok().build();
        }
        GitHubApplicationDescription applicationDescription = this.checkSignature(queryContent, event, signature, appId);
        try {
            return this.processEvent(event, queryContent, applicationDescription.serverUrl);
        }
        catch (ConQATException e) {
            throw new BadRequestException("Invalid request: " + e.getMessage(), (Throwable)e);
        }
    }

    private GitHubApplicationDescription checkSignature(String queryContent, String event, String signature, String appId) throws StorageException {
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        Matcher urlMatcher = URL_PATTERN.matcher(queryContent);
        String gitHubServerUrl = urlMatcher.find() ? urlMatcher.group(1) : "";
        GitHubApplicationDescription description = GitHubAppUtils.loadConfiguredApplication((String)appId, (String)gitHubServerUrl, (ServerOptionIndex)optionIndex, InternalServerErrorException::new);
        if (description == null) {
            LOGGER.error("Could not load app description for app ID: {} and GitHub Server URL {}.", (Object)appId, (Object)gitHubServerUrl);
            throw new BadRequestException("Missing app description!");
        }
        if (StringUtils.isEmpty((String)description.webhookSecret)) {
            return description;
        }
        if (StringUtils.isEmpty((String)signature)) {
            LOGGER.error("Received GitHub request without signature: {}", (Object)event);
            throw new BadRequestException("Missing signature!");
        }
        String sha256 = GitHubApplicationWebHookService.generateWebhookSignature(queryContent.trim(), description.webhookSecret);
        if (!sha256.equals(signature)) {
            LOGGER.error("Received GitHub request with invalid signature: {}", (Object)event);
            throw new BadRequestException("Invalid signature!");
        }
        return description;
    }

    @VisibleForTesting
    public static String generateWebhookSignature(String jsonPayload, String webhookSecret) {
        String digestedQueryContent = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, webhookSecret).hmacHex(jsonPayload);
        return "sha256=" + digestedQueryContent;
    }

    private Response processEvent(String event, @Language(value="JSON") String payload, String appGitHubServerUrl) throws ConQATException {
        return switch (event) {
            case "installation" -> this.handleInstallationEvent(payload, appGitHubServerUrl);
            case "installation_repositories" -> this.handleInstallationRepositoriesEvent(payload);
            case "pull_request" -> this.handlePullRequestEvent(payload, appGitHubServerUrl);
            case "push" -> this.handlePushEvent(payload);
            case "github_app_authorization" -> this.handleGitHubAppAuthorizationEvent(payload);
            case "check_run" -> this.handleCheckRunEvent(payload, appGitHubServerUrl);
            case "status" -> this.handleCommitStatusEvent(payload, appGitHubServerUrl);
            default -> Response.ok().build();
        };
    }

    private Response handleInstallationEvent(@Language(value="JSON") String payload, String appGitHubServerUrl) throws ConQATException {
        InstallationEventPayload installationPayload = (InstallationEventPayload)JsonUtils.deserializeFromJson((String)payload, InstallationEventPayload.class);
        String action = installationPayload.action;
        if ("new_permissions_accepted".equals(action)) {
            return Response.ok().build();
        }
        GitHubInstallationIndex installationIndex = this.openGlobalIndex(GitHubInstallationIndex.class);
        Installation installation = installationPayload.installation;
        OrgOrUserInstallationsKey orgOrUserInstallationsKey = new OrgOrUserInstallationsKey(appGitHubServerUrl, installation.getAccountName());
        List availableRepositories = CollectionUtils.map((Object[])installationPayload.repositories, InstallationRepository::getFullName);
        switch (installationPayload.action) {
            case "created": {
                installationIndex.addInstallation(orgOrUserInstallationsKey, new LongKey(installation.getId()), installation.getAppId(), availableRepositories);
                break;
            }
            case "deleted": {
                installationIndex.removeInstallation(orgOrUserInstallationsKey, installation.getId());
                break;
            }
        }
        return Response.ok().build();
    }

    private Response handleInstallationRepositoriesEvent(@Language(value="JSON") String payload) throws JsonSerializationException, StorageException {
        InstallationRepositoryEventPayload installationRepositoryPayload = (InstallationRepositoryEventPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)payload, InstallationRepositoryEventPayload.class);
        GitHubInstallationIndex installationIndex = this.openGlobalIndex(GitHubInstallationIndex.class);
        Installation installation = installationRepositoryPayload.installation;
        switch (installationRepositoryPayload.action) {
            case "added": {
                installationIndex.addRepositoriesToInstallation(installation.getId(), installationRepositoryPayload.getAddedRepositoriesFullNames());
                break;
            }
            case "removed": {
                installationIndex.removeRepositoriesFromInstallation(installation.getId(), installationRepositoryPayload.getRemovedRepositoriesFullNames());
                break;
            }
        }
        return Response.ok().build();
    }

    private Response handlePullRequestEvent(@Language(value="JSON") String payload, String appGitHubServerUrl) throws ConQATException {
        PullRequestEventPayload pullRequestPayload = (PullRequestEventPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)payload, PullRequestEventPayload.class);
        String action = pullRequestPayload.action;
        String cloneUrl = pullRequestPayload.repository.cloneUrl;
        if (action.equals(SYNCHRONIZE_PULL_REQUEST_ACTION) && GitHubCrossRepositoryMergeRequestHandler.isCrossRepoMergeRequest((GitHubPullRequest)pullRequestPayload.pullRequest)) {
            RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)cloneUrl, (IndexLayer)this.getIndexLayer(), null);
        }
        if (RELEVANT_PULL_REQUEST_ACTIONS.contains(action)) {
            String repositoryName = pullRequestPayload.repository.fullName;
            this.scheduleMergeRequestUpdateTriggers(cloneUrl, repositoryName, pullRequestPayload.number, appGitHubServerUrl, GitHubMergeRequestUpdateTrigger.class, null);
            if (action.equals(OPENED_PULL_REQUEST_ACTION) || action.equals(SYNCHRONIZE_PULL_REQUEST_ACTION)) {
                this.postCheckRunInProgress(pullRequestPayload.number, pullRequestPayload.pullRequest.head().sha(), PlatformRepositoryIdentifier.fromRepositoryName((String)repositoryName));
            }
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCheckRunInProgress(long pullRequestNumber, String headRevision, PlatformRepositoryIdentifier repositoryIdentifier) {
        try {
            new GitHubPendingCheckRunReporter(this.getIndexLayer(), repositoryIdentifier).reportAnalysisInProgress(headRevision, new MergeRequestIdentifier(repositoryIdentifier.asRepositoryName(), pullRequestNumber));
        }
        catch (AnalysisInProgressReporter.ConnectorNotAvailableException e) {
            LOGGER.atDebug().withThrowable((Throwable)e).log("Skipping \"In Progress\" check run for merge request {} in repository {}, because no matching connector is configured.", (Object)pullRequestNumber, (Object)repositoryIdentifier.asRepositoryName());
        }
        catch (Exception e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to post \"In Progress\" check run for merge request {} in repository {}.", (Object)pullRequestNumber, (Object)repositoryIdentifier.asRepositoryName());
        }
        finally {
            try {
                GitHubCheckRunCleanupOption.enable((IndexLayer)this.getIndexLayer());
            }
            catch (Exception e) {
                LOGGER.atWarn().withThrowable((Throwable)e).log("Failed to enable GitHub check run cleanup option.");
            }
        }
    }

    private Response handleCheckRunEvent(@Language(value="JSON") String payload, String appGitHubServerUrl) throws JsonSerializationException, StorageException {
        CheckRunEventPayload checkRunPayload = (CheckRunEventPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)payload, CheckRunEventPayload.class);
        String action = checkRunPayload.action;
        if (RELEVANT_CHECK_RUN_ACTIONS.contains(action) && !GitHubApplicationWebHookService.isTeamscaleCheckRun(checkRunPayload)) {
            PullRequestPayLoad[] affectedPullRequests;
            for (PullRequestPayLoad pullRequest : affectedPullRequests = checkRunPayload.checkRun.pullRequests) {
                this.scheduleMergeRequestUpdateTriggers(checkRunPayload.repository.cloneUrl, checkRunPayload.repository.fullName, pullRequest.number, appGitHubServerUrl, GitHubMergeRequestUpdateTrigger.class, null);
            }
        }
        return Response.ok().build();
    }

    private static boolean isTeamscaleCheckRun(CheckRunEventPayload checkRunPayload) {
        String checkRunName = checkRunPayload.checkRun.name;
        if (StringUtils.isEmpty((String)checkRunName)) {
            return false;
        }
        return StringUtils.startsWithIgnoreCase((String)checkRunName, (String)"Teamscale");
    }

    private Response handleCommitStatusEvent(@Language(value="JSON") String payload, String appGitHubServerUrl) throws JsonSerializationException, StorageException {
        CommitStatusPayload commitStatusPayload = (CommitStatusPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)payload, CommitStatusPayload.class);
        this.scheduleMergeRequestUpdateTriggers(commitStatusPayload.repository.cloneUrl, commitStatusPayload.repository.fullName, commitStatusPayload.sha, appGitHubServerUrl, GitHubMergeRequestUpdateTrigger.class);
        return Response.ok().build();
    }

    private Response handlePushEvent(@Language(value="JSON") String payload) throws JsonSerializationException, StorageException {
        PushEventPayload pushEventPayload = (PushEventPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)payload, PushEventPayload.class);
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)pushEventPayload.repository.cloneUrl, (IndexLayer)this.getIndexLayer(), null);
        return Response.ok().build();
    }

    private Response handleGitHubAppAuthorizationEvent(@Language(value="JSON") String payload) throws ConQATException {
        GitHubAppAuthorizationEventPayload authPayload = (GitHubAppAuthorizationEventPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)payload, GitHubAppAuthorizationEventPayload.class);
        String userName = authPayload.sender.getLogin();
        OAuthTokenIndex oAuthTokenIndex = this.openGlobalIndex(OAuthTokenIndex.class);
        if ("revoked".equals(authPayload.action)) {
            oAuthTokenIndex.removeToken(userName.toLowerCase());
        }
        return Response.ok().build();
    }

    private static class InstallationEventPayload {
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="installation")
        private Installation installation;
        @JsonProperty(value="repositories")
        private InstallationRepository[] repositories;

        private InstallationEventPayload() {
        }
    }

    private static class InstallationRepositoryEventPayload {
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="installation")
        private Installation installation;
        @JsonProperty(value="repositories_added")
        private UpdatedRepositoryPayload[] addedRepositories;
        @JsonProperty(value="repositories_removed")
        private UpdatedRepositoryPayload[] removedRepositories;

        private InstallationRepositoryEventPayload() {
        }

        private List<String> getAddedRepositoriesFullNames() {
            return CollectionUtils.map((Object[])this.addedRepositories, r -> r.fullName);
        }

        private List<String> getRemovedRepositoriesFullNames() {
            return CollectionUtils.map((Object[])this.removedRepositories, r -> r.fullName);
        }
    }

    private static class PullRequestEventPayload {
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="number")
        private long number;
        @JsonProperty(value="repository")
        private RepositoryPayload repository;
        @JsonProperty(value="pull_request")
        private GitHubPullRequest pullRequest;

        private PullRequestEventPayload() {
        }
    }

    public static class RepositoryPayload {
        @JsonProperty(value="full_name")
        private String fullName;
        @JsonProperty(value="clone_url")
        private String cloneUrl;

        @TestOnly
        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        @TestOnly
        public void setCloneUrl(String cloneUrl) {
            this.cloneUrl = cloneUrl;
        }
    }

    private static class CheckRunEventPayload {
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="check_run")
        private CheckRunPayLoad checkRun;
        @JsonProperty(value="repository")
        private RepositoryPayload repository;

        private CheckRunEventPayload() {
        }
    }

    private static class CheckRunPayLoad {
        @JsonProperty(value="pull_requests")
        private PullRequestPayLoad[] pullRequests;
        @JsonProperty(value="name")
        private String name;

        private CheckRunPayLoad() {
        }
    }

    private static class PullRequestPayLoad {
        @JsonProperty(value="number")
        private int number;

        private PullRequestPayLoad() {
        }
    }

    private static class CommitStatusPayload {
        @JsonProperty(value="sha")
        private String sha;
        @JsonProperty(value="repository")
        private RepositoryPayload repository;

        private CommitStatusPayload() {
        }
    }

    public static class PushEventPayload {
        @JsonProperty(value="repository")
        private RepositoryPayload repository;

        @TestOnly
        public void setRepository(RepositoryPayload repository) {
            this.repository = repository;
        }
    }

    private static class GitHubAppAuthorizationEventPayload {
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="sender")
        private GitHubUser sender;

        private GitHubAppAuthorizationEventPayload() {
        }
    }

    private static class UpdatedRepositoryPayload {
        @JsonProperty(value="full_name")
        private String fullName;

        private UpdatedRepositoryPayload() {
        }
    }
}

