/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.config;

import io.prometheus.metrics.config.PrometheusPropertiesException;
import io.prometheus.metrics.config.Util;
import java.util.Map;
import javax.annotation.Nullable;

public class ExemplarsProperties {
    private static final String PREFIX = "io.prometheus.exemplars";
    private static final String MIN_RETENTION_PERIOD_SECONDS = "minRetentionPeriodSeconds";
    private static final String MAX_RETENTION_PERIOD_SECONDS = "maxRetentionPeriodSeconds";
    private static final String SAMPLE_INTERVAL_MILLISECONDS = "sampleIntervalMilliseconds";
    @Nullable
    private final Integer minRetentionPeriodSeconds;
    @Nullable
    private final Integer maxRetentionPeriodSeconds;
    @Nullable
    private final Integer sampleIntervalMilliseconds;

    private ExemplarsProperties(@Nullable Integer minRetentionPeriodSeconds, @Nullable Integer maxRetentionPeriodSeconds, @Nullable Integer sampleIntervalMilliseconds) {
        this.minRetentionPeriodSeconds = minRetentionPeriodSeconds;
        this.maxRetentionPeriodSeconds = maxRetentionPeriodSeconds;
        this.sampleIntervalMilliseconds = sampleIntervalMilliseconds;
    }

    @Nullable
    public Integer getMinRetentionPeriodSeconds() {
        return this.minRetentionPeriodSeconds;
    }

    @Nullable
    public Integer getMaxRetentionPeriodSeconds() {
        return this.maxRetentionPeriodSeconds;
    }

    @Nullable
    public Integer getSampleIntervalMilliseconds() {
        return this.sampleIntervalMilliseconds;
    }

    static ExemplarsProperties load(Map<Object, Object> properties) throws PrometheusPropertiesException {
        Integer minRetentionPeriodSeconds = Util.loadInteger("io.prometheus.exemplars.minRetentionPeriodSeconds", properties);
        Integer maxRetentionPeriodSeconds = Util.loadInteger("io.prometheus.exemplars.maxRetentionPeriodSeconds", properties);
        Integer sampleIntervalMilliseconds = Util.loadInteger("io.prometheus.exemplars.sampleIntervalMilliseconds", properties);
        Util.assertValue(minRetentionPeriodSeconds, t -> t > 0, "Expecting value > 0.", PREFIX, MIN_RETENTION_PERIOD_SECONDS);
        Util.assertValue(maxRetentionPeriodSeconds, t -> t > 0, "Expecting value > 0.", PREFIX, MAX_RETENTION_PERIOD_SECONDS);
        Util.assertValue(sampleIntervalMilliseconds, t -> t > 0, "Expecting value > 0.", PREFIX, SAMPLE_INTERVAL_MILLISECONDS);
        if (minRetentionPeriodSeconds != null && maxRetentionPeriodSeconds != null && minRetentionPeriodSeconds > maxRetentionPeriodSeconds) {
            throw new PrometheusPropertiesException("io.prometheus.exemplars.minRetentionPeriodSeconds must not be greater than io.prometheus.exemplars.maxRetentionPeriodSeconds.");
        }
        return new ExemplarsProperties(minRetentionPeriodSeconds, maxRetentionPeriodSeconds, sampleIntervalMilliseconds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private Integer minRetentionPeriodSeconds;
        @Nullable
        private Integer maxRetentionPeriodSeconds;
        @Nullable
        private Integer sampleIntervalMilliseconds;

        private Builder() {
        }

        public Builder minRetentionPeriodSeconds(int minRetentionPeriodSeconds) {
            this.minRetentionPeriodSeconds = minRetentionPeriodSeconds;
            return this;
        }

        public Builder maxRetentionPeriodSeconds(int maxRetentionPeriodSeconds) {
            this.maxRetentionPeriodSeconds = maxRetentionPeriodSeconds;
            return this;
        }

        public Builder sampleIntervalMilliseconds(int sampleIntervalMilliseconds) {
            this.sampleIntervalMilliseconds = sampleIntervalMilliseconds;
            return this;
        }

        public ExemplarsProperties build() {
            return new ExemplarsProperties(this.minRetentionPeriodSeconds, this.maxRetentionPeriodSeconds, this.sampleIntervalMilliseconds);
        }
    }
}

