import{_ as t,h as o,ak as i,g as a}from"./chunks/framework.B7a_7emw.js";const n="/assets/gitea-pr-integration.DffoNJCk.png",u=JSON.parse('{"title":"Connecting to Gitea","description":"This article describes how you can connect Teamscale to a Gitea instance.","frontmatter":{"title":"Connecting to Gitea","description":"This article describes how you can connect Teamscale to a Gitea instance."},"headers":[],"relativePath":"howto/connecting-version-control-system/gitea/index.md","filePath":"howto/connecting-version-control-system/gitea/index.md"}'),s={name:"howto/connecting-version-control-system/gitea/index.md"};function r(c,e,l,h,m,p){return a(),o("div",null,[...e[0]||(e[0]=[i('<h1 id="how-to-connect-teamscale-to-gitea" tabindex="-1">How to Connect Teamscale to Gitea <a class="header-anchor" href="#how-to-connect-teamscale-to-gitea" aria-label="Permalink to &quot;How to Connect Teamscale to Gitea&quot;">​</a></h1><p>Teamscale communicates with Gitea using its REST API and webhooks. You don&#39;t need to install plugins in Gitea or change admin settings.</p><div class="tip custom-block"><p class="custom-block-title">General Option Reference</p><p>This guide only covers the options specific for the Gitea repository connector. A general overview of connector options is <a href="./../../../reference/connector-options/">available here</a>.</p></div><p><img src="'+n+'" alt="Screenshot of Teamscale&#39;s Gitea pull request integration" width="985" height="980" data-zoom="true"></p><h3 id="prerequisites-for-gitea-integration" tabindex="-1">Prerequisites for Gitea Integration <a class="header-anchor" href="#prerequisites-for-gitea-integration" aria-label="Permalink to &quot;Prerequisites for Gitea Integration&quot;">​</a></h3><p>To integrate with Gitea, a technical user with access to the repository is needed. The technical user can either be added directly to the repository as a <em>Collaborator</em> or to a <em>Team</em> at organization level, which allows more fine-grained permission management. The following permissions are needed depending on the used functionality:</p><ul><li><p>Minimal permissions:</p><ul><li>Read access to <em>Code</em></li></ul></li><li><p>Additionally for the pull request integrations:</p><ul><li>Read access to <em>Pull Requests</em> for line comments</li><li>Write access to <em>Pull Requests</em> for badges (findings and test gaps)</li><li>Write access to <em>Code</em> for voting</li></ul></li><li><p>For automatic webhook creation:</p><ul><li>Admin access to the repository. Alternatively, you can <a href="#manual-creation-of-webhooks">configure webhooks manually</a>.</li></ul></li></ul><h3 id="project-configuration-steps" tabindex="-1">Project Configuration Steps <a class="header-anchor" href="#project-configuration-steps" aria-label="Permalink to &quot;Project Configuration Steps&quot;">​</a></h3><p>To connect a Teamscale project to a Gitea repository, follow these steps:</p><ol><li><p>Ensure that the <a href="./../../../reference/admin-settings/server-settings/#teamscale-instance-base-url">Teamscale instance base URL</a> is configured correctly.</p></li><li><p>Select the <strong>Gitea connector</strong> during project creation.</p></li><li><p>Select or create an <strong>account</strong> for the Gitea server:</p><ul><li><strong><em>URI</em></strong>: The root URL of the Gitea server (i.e., it is not repository specific).</li><li><strong><em>Username</em></strong>: The username of the technical user for Teamscale. Must be empty if an access token is used.</li><li><strong><em>Password</em></strong>: Either the password or an <strong>access token</strong> of the technical user with scope <code>write:repository</code>.</li></ul><p>To obtain an access token in Gitea, navigate to the technical user&#39;s settings page and select <em>Applications</em>.</p></li><li><p>Complete the configuration by providing the name of the repository including its owner (e.g. <code>my-user/my-repo</code> or <code>my-organization/my-repo</code>) and completing any other required fields.</p></li></ol><p>As the first step in project creation, Teamscale will register its webhook with the repository. After this, Teamscale will automatically be informed about events in the repository, such as pushes to the repository and changes to pull requests.</p><div class="tip custom-block"><p class="custom-block-title">Webhook Restrictions</p><p>Since Gitea only sends webhooks to allowed hosts, you might have to add the Teamscale server to the <code>ALLOWED_HOST_LIST</code> in the <code>[webhook]</code> section of the Gitea config (<code>app.ini</code>).</p><p>See <a href="https://docs.gitea.com/administration/config-cheat-sheet#webhook-webhook" target="_blank" rel="noreferrer">Gitea config cheat sheet</a></p></div><h3 id="manual-creation-of-webhooks" tabindex="-1">Manual Creation of Webhooks <a class="header-anchor" href="#manual-creation-of-webhooks" aria-label="Permalink to &quot;Manual Creation of Webhooks&quot;">​</a></h3><p>In case the technical user does not have admin permissions to the repository, you can manually create and configure webhooks.</p><p>First, disable automatic webhook creation in Teamscale as described <a href="./../../configuring-post-commit-hooks/#disable-automatic-webhook-creation">here</a>. Otherwise, creating the project will fail.</p><p>Then, add the webhook in the Gitea:</p><ol><li>Open the Gitea repository you want to add the webhook to.</li><li>From <em>Settings</em>, click <em>Webhooks</em>.</li><li>Click <em>Add Webhook</em> and select <em>Gitea</em>.</li><li>Configure the webhook as follows: <ul><li><strong><em>Target URL</em></strong>: The URL of Teamscale&#39;s Gitea endpoint: <code>&lt;Teamscale_baseURL&gt;/api/gitea/web-hook</code></li><li><strong><em>HTTP Method</em></strong>: <code>POST</code></li><li><strong><em>POST Content Type</em></strong>: <code>application/json</code></li><li><strong><em>Secret</em></strong>: Leave empty</li><li><strong><em>Trigger On</em></strong>: <ul><li>Select <em>Custom Events...</em> with the following events: <ul><li>Repository Events: Push</li><li>Pull Request Events: Pull Request</li></ul></li><li><em>Branch filter</em>: <code>*</code></li><li><em>Authorization Header</em>: Leave empty</li></ul></li></ul></li><li>Make sure the <em>Active</em> checkbox is checked and click <em>Add webhook</em>.</li></ol>',17)])])}const g=t(s,[["render",r]]);export{u as __pageData,g as default};
