This check detects `DELETE` and `UPDATE` statements hat do not include a filtering condition to restrict changes to specific records.
It ensures that database modifications are intentional and do not accidentally affect all rows.

# Why is This a Problem?

When using `DELETE` and `UPDATE` statements without a filtering condition the corresponding query applies the changes to **all** records in the specified database.
This is most likely unintended and should be avoided.

# How Can I Resolve This?

You should always ensure that `DELETE` and `UPDATE` statements target specific records.
Use a `WHERE` clause whenever possible to define which records should be modified.
When using `UPDATE ... JOIN`, ensure the `JOIN` acts as a filtering mechanism that limits changes only to necessary records.

## Example (Before)

```SQL
DELETE FROM someTable;

UPDATE someTable
SET last_attribute = 'Some Value';
```

## Example (After)

```SQL
DELETE FROM someTable
WHERE id = someId; -- this can be any condition applying o the records in the DB

UPDATE someTable
SET last_attribute = 'Some Value'
WHERE id = someId; -- this can be any condition applying o the records in the DB
```

# Where Can I Learn More?

## Guidelines

## References
- [Oracletutorial: Oracle Update](https://www.oracletutorial.com/oracle-basics/oracle-update/)
- [Oracletutorial: Oracle Delete](https://www.oracletutorial.com/oracle-basics/oracle-delete/)
- [Microsoft T-SQL Reference: UPDATE (Transact-SQL)](https://learn.microsoft.com/en-us/sql/t-sql/queries/update-transact-sql)
- [Microsoft T-SQL Reference: DELETE (Transact-SQL)](https://learn.microsoft.com/en-us/sql/t-sql/statements/delete-transact-sql)