Invalid message types lead to runtime errors.

# What Does This Check Look For?

This check reports a finding for invalid message types selected after `MESSAGE [...] TYPE` and
`MESSAGE [...] DISPLAY LIKE`.

Valid types are : `'A'`, `'E'`,`'I'`,`'S'`,`'W'` and `'X'`.

Notice message types in ABAP error handling are case-sensitive.

# Why is This a Problem?

Invalid message types lead to short dumps.

Although the `MESSAGE [...] INTO` clause is documented to ignore the message type, they still produce a shortdump upon an invalid type. 
# How Can I Resolve This?

Replace the invalid message type with a valid one.

# Examples
## Non-Compliant

```$LANGUAGE
CATCH fault INTO error.
    MESSAGE error TYPE 'd' DISPLAY LIKE my_type.
```

## Compliant

```$LANGUAGE
CATCH fault INTO error.
    MESSAGE error TYPE 'S' DISPLAY LIKE 'E'.
```

# Where Can I Learn More?

- [ABAP - Keyword Documentation: MESSAGE](https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-US/abapmessage.htm)
