Each external object or function should be declared only once (in the entire project). This helps to reduce the number of places we have to change, when modifying global variables or objects.

*Noncompliant Example*

```cpp
/* file a.c */
int my_global = 42;

/* file b.c */
extern int my_global;

/* file c.c */
extern int my_global;  // error, should not hve second extern declaration
```

*Compliant Example*

```cpp
/* file a.c */
int my_global = 42;

/* file a.h */
extern int my_global;

/* file b.c */
#include "a.h"

/* file c.c */
#include "a.h"

```
