# Description
Various checks regarding `SELECT` performance.

# Extended Information
`ENDSELECT`: not reported when the corresponding `SELECT` has `PACKAGE SIZE`

`SELECT *`: not reported if using `INTO/APPENDING CORRESPONDING FIELDS OF`

# Examples
**Bad example**
```abap
SELECT field1, field2 FROM table
    INTO @DATA(structure) UP TO 1 ROWS ORDER BY field3 DESCENDING.
ENDSELECT.
```

**Good example**
```abap
SELECT field1, field2 FROM table UP TO 1 ROWS
  INTO TABLE @DATA(table) ORDER BY field3 DESCENDING
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/select_performance) <br>
