Imports from `__future__` should be the first imports in a file.

### Anti-pattern

In this example, `namedtuple` is imported before `__future__.print_function`.

```python
from collections import namedtuple

from __future__ import print_function
```

### Best practice

To fix the issue we switch the order of the imports so that all `__future__` imports come first.

```python
from __future__ import print_function

from collections import namedtuple
```
