<p>A magic number is a hard-coded numerical value that may lack context or meaning. They should not be used because they can make the code less
readable and maintainable.</p>
<h2>Why is this an issue?</h2>
<p>Magic numbers make the code more complex to understand as it requires the reader to have knowledge about the global context to understand the
number itself. Their usage may seem obvious when writing the code, but it may not be the case for another developer or later once the context faded
away. -1, 0, and 1 are not considered magic numbers.</p>
<h3>Exceptions</h3>
<p>This rule doesn’t raise an issue when the magic number is used as part of:</p>
<ul>
  <li> the <code>GetHashCode</code> method </li>
  <li> a variable/field declaration </li>
  <li> the single argument of an attribute </li>
  <li> a named argument for a method or attribute </li>
  <li> a constructor call </li>
  <li> a default value for a method argument </li>
</ul>
<h2>How to fix it</h2>
<p>Replacing them with a constant allows us to provide a meaningful name associated with the value. Instead of adding complexity to the code, it
brings clarity and helps to understand the context and the global meaning.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
public void DoSomething()
{
    for (int i = 0; i &lt; 4; i++)  // Noncompliant, 4 is a magic number
    {
        ...
    }
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
private const int NUMBER_OF_CYCLES = 4;

public void DoSomething()
{
    for (int i = 0; i &lt; NUMBER_OF_CYCLES; i++)  // Compliant
    {
        ...
    }
}
</pre>

