<h2>Why is this an issue?</h2>
<p>Placing an <code>if</code> statement on the same line as the closing <code>}</code> from a preceding <code>if</code>, <code>else</code>, or
<code>else if</code> block can lead to confusion and potential errors. It may indicate a missing <code>else</code> statement or create ambiguity for
maintainers who might fail to understand that the two statements are unconnected.</p>
<p>The following code snippet is confusing:</p>
<pre data-diff-id="1" data-diff-type="noncompliant">
if (condition1) {
  // ...
} if (condition2) {  // Noncompliant
  //...
}
</pre>
<p>Either the two conditions are unrelated and they should be visually separated:</p>
<pre data-diff-id="1" data-diff-type="compliant">
if (condition1) {
  // ...
}

if (condition2) {
  //...
}
</pre>
<p>Or they were supposed to be exclusive and you should use <code>else if</code> instead:</p>
<pre>
if (condition1) {
  // ...
} else if (condition2) {
  //...
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/selection-statements#the-if-statement">If statement</a>
  </li>
</ul>

