﻿## SA1019

<table>
<tr>
  <td>TypeName</td>
  <td>SA1019MemberAccessSymbolsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1019</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

The spacing around a member access symbol is incorrect, within a C# code file.

## Rule description

A violation of this rule occurs when the spacing around a member access symbol is incorrect. A member access symbol should not have whitespace on either side, unless it is the first character on the line.

## How to fix violations

To fix a violation of this rule, ensure that the member access symbol is not surrounded by any whitespace.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1019:MemberAccessSymbolsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1019 // MemberAccessSymbolsMustBeSpacedCorrectly
#pragma warning restore SA1019 // MemberAccessSymbolsMustBeSpacedCorrectly
```
