﻿## SA1023

<table>
<tr>
  <td>TypeName</td>
  <td>SA1023DereferenceAndAccessOfMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1023</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A dereference symbol or an access-of symbol within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around a dereference or access-of symbol is not correct.

The spacing around the symbol depends upon whether the symbol is used within a type declaration. If so, the symbol should always be followed by a single space, unless it is the last character on the line, or is followed by an opening square bracket or a parenthesis. In addition, the symbol should not be preceded by whitespace, and should not be the first character on the line. An example of a properly spaced dereference symbol used within a type declaration is:

```csharp
object* x = null;
```

When a dereference or access-of symbol is used outside of a type declaration, the opposite rule applies. In this case, the symbol should always be preceded by a single space, unless it is the first character on the line, or is preceded by an opening square bracket, a parenthesis or a symbol of the same type i.e. an equals. The symbol should not be followed by whitespace, and should not be the last character on the line. For example:

```csharp
y = *x;
```

## How to fix violations

To fix a violation of this rule, ensure that the spacing around the dereference or address-of symbol follows the rule described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1023:DereferenceAndAccessOfMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1023 // DereferenceAndAccessOfMustBeSpacedCorrectly
#pragma warning restore SA1023 // DereferenceAndAccessOfMustBeSpacedCorrectly
```
