# SA1103

<table>
<tr>
  <td>Title</td>
  <td>Query clauses should be on separate lines or all on one line</td>
</tr>
<tr>
  <td>TypeName</td>
  <td>SA110xQueryClauses</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1103</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The clauses within a C# query expression are not all placed on the same line, and each clause is not placed on its own line.

## Rule description

A violation of this rule occurs when the query clauses are not either placed all on the same line, or each on its own line. For example:
```c#
    object x = from num in numbers
        select num;
```

The query clauses can correctly be written as:
```c#
    object x = from num in numbers select num;
```
or:
```c#
    object x =
        from num in numbers
        select num;
```
 
## How to fix violations

To fix a violation of this rule, ensure that all clauses are placed together on the same line, or each clause begins on its own line.

## How to suppress violations

```c#
#pragma warning disable SA1103 // Query clauses should be on separate lines or all on one line
    object x = from num in numbers
        select num;
#pragma warning restore SA1103 // Query clauses should be on separate lines or all on one line
```
