## SA1135

<table>
<tr>
  <td>TypeName</td>
  <td>SA1135UsingDirectivesMustBeQualified</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1135</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

A using directive is not qualified.

## Rule description

 A violation of this rule occurs when a using directive is contained within a namespace and is not qualified.
 Note that alias definitions of classes within the same namespace do not need to be qualified.

For example, the following code would produce a violation of this rule:

```csharp
namespace System.Threading
{
    using IO;
    using Tasks;
}
```

The following code would not produce any violations:

```csharp
namespace System.Threading
{
    using System.IO;
    using System.Threading.Tasks;

    using T = Thread;
}
```

## How to fix violations

To fix a violation of this rule, use the full qualified namespace name.

## How to suppress violations

```csharp
namespace N1.N2
{
#pragma warning disable SA1135 // Using directives must be qualified
    using N3;
#pragma warning restore SA1135 // Using directives must be qualified
}
```
