﻿## SA1208

<table>
<tr>
  <td>TypeName</td>
  <td>SA1208SystemUsingDirectivesMustBePlacedBeforeOtherUsingDirectives</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1208</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

A using directive which declares a member of the *System* namespace appears after a using directive which declares a member of a different namespace, within a C# code file.

## Rule description

A violation of this rule occurs when a using directive for the *System* namespace is placed after a non-*System* using directive. Placing all *System* using directives at the top of the using directives can make the code cleaner and easier to read, and can help make it easier to identify the namespaces that are being used by the code.

## How to fix violations

To fix an instance of this violation, place the *System* using directive above all using directives for other namespaces.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1208:SystemUsingDirectivesMustBePlacedBeforeOtherUsingDirectives", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1208 // SystemUsingDirectivesMustBePlacedBeforeOtherUsingDirectives
#pragma warning restore SA1208 // SystemUsingDirectivesMustBePlacedBeforeOtherUsingDirectives
```
