﻿## SA1214

<table>
<tr>
  <td>TypeName</td>
  <td>SA1214ReadonlyElementsMustAppearBeforeNonReadonlyElements</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1214</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

A readonly field is positioned beneath a non-readonly field.

## Rule description

A violation of this rule occurs when a readonly field is positioned beneath a non-readonly field.

## How to fix violations

To fix an instance of this violation, place all readonly fields above all non-readonly fields.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1214:ReadonlyElementsMustAppearBeforeNonReadonlyElements", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1214 // ReadonlyElementsMustAppearBeforeNonReadonlyElements
#pragma warning restore SA1214 // ReadonlyElementsMustAppearBeforeNonReadonlyElements
```
