﻿## SA1410

<table>
<tr>
  <td>TypeName</td>
  <td>SA1410RemoveDelegateParenthesisWhenPossible</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1410</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

A call to a C# anonymous method does not contain any method parameters, yet the statement still includes parenthesis.

## Rule description

When an anonymous method does not contain any method parameters, the parenthesis around the parameters are optional.

A violation of this rule occurs when the parenthesis are present on an anonymous method call which takes no method parameters. For example:

```csharp
this.Method(delegate() { return 2; });
```

The parenthesis are unnecessary and should be removed:

```csharp
this.Method(delegate { return 2; });
```

## How to fix violations

Remove the unnecessary parenthesis after the delegate keyword.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1410:RemoveDelegateParenthesisWhenPossible", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1410 // RemoveDelegateParenthesisWhenPossible
#pragma warning restore SA1410 // RemoveDelegateParenthesisWhenPossible
```
