﻿## SA1604

<table>
<tr>
  <td>TypeName</td>
  <td>SA1604ElementDocumentationMustHaveSummary</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1604</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The Xml header documentation for a C# element is missing a `<summary>` tag.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when the element documentation is missing a `<summary>` tag.

## How to fix violations

To fix a violation of this rule, add and fill-in a `<summary>` tag for the element, containing a description of the element.

The following example shows a class containing invalid Xml within its documentation header. The closing tag for the `<summary>` node is invalid.

```csharp
/// <summary>
/// Represents a customer in the database.
/// </summary>
public class Customer
{
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1604:ElementDocumentationMustHaveSummary", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1604 // ElementDocumentationMustHaveSummary
#pragma warning restore SA1604 // ElementDocumentationMustHaveSummary
```
