<h2>Why is this an issue?</h2>
<p><code>Object.finalize()</code> is called by the Garbage Collector at some point after the object becomes unreferenced.</p>
<p>In general, overloading <code>Object.finalize()</code> is a bad idea because:</p>
<ul>
  <li> The overload may not be called by the Garbage Collector. </li>
  <li> Users are not expected to call <code>Object.finalize()</code> and will get confused. </li>
</ul>
<p>But beyond that it’s a terrible idea to name a method "finalize" if it doesn’t actually override <code>Object.finalize()</code>.</p>
<h3>Noncompliant code example</h3>

```java
public int finalize(int someParameter) {        // Noncompliant
  /* ... */
}
```
<h3>Compliant solution</h3>

```java
public int someBetterName(int someParameter) {  // Compliant
  /* ... */
}
```