<h2>Why is this an issue?</h2>
<p>If all the keys in a <code>Map</code> are values from a single enum, it is recommended to use an <code>EnumMap</code> as the specific
implementation. An <code>EnumMap</code>, which has the advantage of knowing all possible keys in advance, is more efficient compared to other
implementations, as it can use a simple array as its underlying data structure.</p>
<h3>Noncompliant code example</h3>

```java
public enum Color {
  RED, GREEN, BLUE, ORANGE;
}

Map<Color, String> colorMap = new HashMap<>(); // Noncompliant
```
<h3>Compliant solution</h3>

```java
public enum Color {
  RED, GREEN, BLUE, ORANGE;
}

Map<Color, String> colorMap = new EnumMap<>(Color.class); // Compliant
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://www.baeldung.com/java-enum-map">A Guide to EnumMap - Baeldung</a> </li>
</ul>