<h2>Why is this an issue?</h2>
<p>An infinite loop will never end while the program runs, meaning you have to kill the program to get out of the loop. Every loop should have an end
condition, whether by meeting the loop’s termination condition or via a <code>break</code> statement.</p>
<h3>Noncompliant code example</h3>

```java
for (;;) {  // Noncompliant; end condition omitted
  // ...
}
```

```java
int j;
while (true) { // Noncompliant; end condition omitted
  j++;
}
```

```java
int k;
boolean b = true;
while (b) { // Noncompliant; b never written to in loop
  k++;
}
```
<h3>Compliant solution</h3>

```java
int j;
while (true) { // reachable end condition added
  j++;
  if (j  == Integer.MIN_VALUE) {  // true at Integer.MAX_VALUE +1
    break;
  }
}
```

```java
int k;
boolean b = true;
while (b) {
  k++;
  b = k < Integer.MAX_VALUE;
}
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/lzZGBQ">CERT, MSC01-J.</a> - Do not use an empty infinite loop </li>
</ul>