<h2>Why is this an issue?</h2>
<p>Having a variable with the same name in two unrelated classes is fine, but do the same thing within a class hierarchy and you’ll get confusion at
best, chaos at worst.</p>
<h3>Noncompliant code example</h3>

```java
public class Fruit {
  protected Season ripe;
  protected Color flesh;

  // ...
}

public class Raspberry extends Fruit {
  private boolean ripe;  // Noncompliant
  private static Color FLESH; // Noncompliant
}
```
<h3>Compliant solution</h3>

```java
public class Fruit {
  protected Season ripe;
  protected Color flesh;

  // ...
}

public class Raspberry extends Fruit {
  private boolean ripened;
  private static Color FLESH_COLOR;

}
```
<h3>Exceptions</h3>
<p>This rule ignores same-name fields that are <code>static</code> in both the parent and child classes. This rule ignores <code>private</code> parent
class fields, but in all other such cases, the child class field should be renamed.</p>

```java
public class Fruit {
  private Season ripe;
  // ...
}

public class Raspberry extends Fruit {
  private Season ripe;  // Compliant as parent field 'ripe' is anyway not visible from Raspberry
  // ...
}
```