<h2>Why is this an issue?</h2>
<p>It is convention to name each class’s logger for the class itself. Doing so allows you to set up clear, communicative logger configuration. Naming
loggers by some other convention confuses configuration, and using the same class name for multiple class loggers prevents the granular configuration
of each class' logger. Some libraries, such as SLF4J warn about this, but not all do.</p>
<p>This rule raises an issue when a logger is not named for its enclosing class.</p>
<h3>Noncompliant code example</h3>

```java
public class MyClass {
  private final static Logger LOG = LoggerFactory.getLogger(WrongClass.class);  // Noncompliant; multiple classes using same logger
}
```
<h3>Compliant solution</h3>

```java
public class MyClass {
  private final static Logger LOG = LoggerFactory.getLogger(MyClass.class);
}
```