<h2>Why is this an issue?</h2>
<p>Resources that can be reused across multiple invocations of the Lambda function should be initialized at construction time. For example in the
constructor of the class, or in field initializers. This way, when the same container is reused for multiple function invocations, the existing
instance can be reused, along with all resources stored in its fields. It is a good practice to reuse SDK clients and database connections by
initializing them at class construction time, to avoid recreating them on every lambda invocation. Failing to do so can lead to performance
degradation, and when not closed properly, even out of memory errors.</p>
<p>This rule reports an issue when the SDK client or the database connection is initialized locally inside a Lambda function.</p>
<h3>Noncompliant code example</h3>

```java
public class App implements RequestHandler<Object, Object> {
    @Override
    public Object handleRequest(final Object input, final Context context) {
      S3Client s3Client = DependencyFactory.s3Client();
      s3Client.listBuckets();
      // ...
    }
}
```
<h3>Compliant solution</h3>

```java
public class App implements RequestHandler<Object, Object> {
    private final S3Client s3Client;

    public App() {
      s3Client = DependencyFactory.s3Client();
    }

    @Override
    public Object handleRequest(final Object input, final Context context) {
      s3Client.listBuckets();
      // ...
    }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://aws.amazon.com/fr/blogs/developer/tuning-the-aws-java-sdk-2-x-to-reduce-startup-time/">Tuning the AWS Java SDK 2.x to reduce
  startup time</a> </li>
  <li> <a href="https://docs.aws.amazon.com/lambda/latest/dg/best-practices.html">Best practices for working with AWS Lambda functions</a> </li>
  <li> <a href="https://aws.amazon.com/fr/blogs/compute/container-reuse-in-lambda/">Understanding Container Reuse in AWS Lambda</a> </li>
</ul>