<h2>Why is this an issue?</h2>
<p>As stated per effective java :</p>
<blockquote>
  <p>Varargs methods are a convenient way to define methods that require a variable number of arguments, but they should not be overused. They can
  produce confusing results if used inappropriately.</p>
</blockquote>
<h3>Noncompliant code example</h3>

```java
void fun ( String... strings )	// Noncompliant
{
  // ...
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/display/java/DCL57-J.+Avoid+ambiguous+overloading+of+variable+arity+methods">CERT, DCL57J</a> -
  Avoid ambiguous overloading of variable arity methods </li>
</ul>