<h2>Why is this an issue?</h2>
<p>Creating an object without assigning it to a variable or using it in any function means the object is essentially created for no reason and may be
dropped immediately without being used. Most of the time, this is due to a missing piece of code and could lead to an unexpected behavior.</p>
<p>If it’s intended because the constructor has side effects, that side effect should be moved into a separate method and called directly. This can
help to improve the performance and readability of the code.</p>

```js
new MyConstructor(); // Noncompliant: object may be dropped
```
<p>Determine if the objects are necessary for the code to function correctly. If they are not required, remove them from the code. Otherwise, assign
them to a variable for later use.</p>

```js
let something = new MyConstructor();
```
<h3>Exceptions</h3>
<ul>
  <li> Creating new objects inside a <code>try</code> block is ignored. </li>
</ul>

```js
try {
  new MyConstructor();
} catch (e) {
  /* ... */
}
```
<ul>
  <li> Known constructors with side effects like <code>Notification</code> or <code>Vue</code> are also ignored. </li>
</ul>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/constructor"><code>Object.prototype.constructor</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes/constructor">constructor</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/new"><code>new</code> operator</a> </li>
</ul>