<h2>Why is this an issue?</h2>
<p>Duplicated string literals make the process of refactoring complex and error-prone, as any change would need to be propagated on all
occurrences.</p>
<h3>Exceptions</h3>
<p>To prevent generating some false-positives, literals having 5 or less characters are excluded as well as literals containing only letters, digits
and '_'.</p>
<h2>How to fix it</h2>
<p>Instead, use constants to replace the duplicated string literals. Constants can be referenced from many places, but only need to be updated in a
single place.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>With the default threshold of 3:</p>

```kotlin
class A {
    fun run() {
        prepare("string literal")    // Noncompliant - "string literal" is duplicated 3 times
        execute("string literal")
        release("string literal")
    }

    fun method() {
        println("'")                 // Compliant - literal "'" has less than 5 characters and is excluded
        println("'")
        println("'")
    }
}
```
<h4>Compliant solution</h4>

```kotlin
class A {
    companion object {
        const val CONSTANT = "string literal"
    }

    fun run() {
        prepare(CONSTANT)    // Compliant
        execute(CONSTANT)
        release(CONSTANT)
    }
}
```