<h2>Why is this an issue?</h2>
<p>Duplicated string literals make the process of refactoring complex and error-prone, as any change would need to be propagated on all
occurrences.</p>
<h3>Exceptions</h3>
<p>No issue will be raised on:</p>
<ul>
  <li> strings with less than 5 characters </li>
  <li> strings with only letters, numbers, underscores, hyphens and periods </li>
</ul>
<h2>How to fix it</h2>
<p>Use constants to replace the duplicated string literals. Constants can be referenced from many places, but only need to be updated in a single
place.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>With the default threshold of 3:</p>

```php
function run() {
  prepare('this is a duplicate'); // Noncompliant - 'this is a duplicate' is duplicated 3 times
  execute('this is a duplicate');
  release('this is a duplicate');
}
```
<h4>Compliant solution</h4>

```php
MESSAGE = 'this is a duplicate';

function run() {
  prepare(MESSAGE); // Compliant - the duplicated string literal is replaced by a constant and can be safely re-used
  execute(MESSAGE);
  release(MESSAGE);
}
```

```php
$severity = $request->getParam('severity-score');
```