<h2>Why is this an issue?</h2>
<p>Well-named functions can allow the users of your code to understand at a glance what to expect from the function - even before reading the
documentation. Toward that end, methods returning a boolean property should have names that start with "is" or "has" rather than with "get".</p>
<p>Note that this rule will only apply to functions that are documented to return a boolean.</p>
<h3>Noncompliant code example</h3>

```php
/**
 * @return boolean
 */
public function getFoo() // Noncompliant
{
  return foo;
}
```
<h3>Compliant solution</h3>

```php
/**
 * @return boolean
 */
public function isFoo()
{
  return true;
}
```