<h2>Why is this an issue?</h2>
<p>Alternation is used to match a single regular expression out of several possible regular expressions. If one of the alternatives is empty it would
match any input, which is most probably a mistake.</p>
<h3>Noncompliant code example</h3>

```ts
/Jack|Peter|/.test('John'); // Noncompliant - returns 'true'
/Jack||Peter/.test('John'); // Noncompliant - returns 'true'
```
<h3>Compliant solution</h3>

```ts
/Jack|Peter/.test('John'); // returns 'false'
```
<h3>Exceptions</h3>
<p>One could use an empty alternation to make a regular expression group optional. Rule will not report on such cases.</p>

```ts
/mandatory(-optional|)/.test('mandatory'); // returns 'true'
/mandatory(-optional|)/.test('mandatory-optional'); // returns 'true'
```
<p>However, if there is a quantifier after the group the issue will be reported as using both <code>|</code> and quantifier is redundant.</p>

```ts
/mandatory(-optional|)?/.test('mandatory'); // Noncompliant - using both `|` inside the group and `?` for the group.
```