<h2>Why is this an issue?</h2>
<p>JavaScript has a prototypal inheritance model. Each object has an internal property that points to another object, called a <code>prototype</code>.
That prototype object has a prototype of its own, and the whole sequence is called a <strong>prototype chain</strong>. When accessing a property or a
method of an object, if it is not found at the top level, the search continues through the object’s prototype and then further down the prototype
chain. This feature allows for very powerful dynamic inheritance patterns but can also lead to confusion when compared to the classic inheritance.</p>
<p>To simplify the access to the prototype of an object some browsers introduced the <code>__proto__</code> property, which was later deprecated and
removed from the language. The current ECMAScript standard includes <code>Object.getPrototypeOf</code> and <code>Object.setPrototypeOf</code> static
methods that should be used instead of the <code>__proto__</code> property.</p>

```ts
let prototype = foo.__proto__;  // Noncompliant: use Object.getPrototypeOf
foo.__proto__ = bar; // Noncompliant: use Object.setPrototypeOf
```
<p>To fix your code replace <code>__proto__</code> with calls to <code>Object.getPrototypeOf</code> and <code>Object.setPrototypeOf</code> static
methods.</p>

```ts
let prototype = Object.getPrototypeOf(foo);
Object.setPrototypeOf(foo, bar);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Inheritance_and_the_prototype_chain">inheritance and the
  prototype chain</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/proto">__proto__</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/getPrototypeOf">Object.getPrototypeOf</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/setPrototypeOf">Object.setPrototypeOf</a> </li>
</ul>