/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.wia;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.wia.EWorkItemType;
import com.teamscale.wia.ExternalToolIssueCustomField;
import com.teamscale.wia.ManualTestCase;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="workItemType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SpecItem.class, name="SPEC_ITEM"), @JsonSubTypes.Type(value=ManualTestCase.class, name="TEST_ITEM")})
@IndexValueClass(containedInBackup=true)
public class SpecItem
extends TeamscaleIssue {
    private static final long serialVersionUID = 1L;
    private static final String ADDITIONAL_ASSIGNEE_PROPERTY_NAME = "additionalAssignees";
    private static final String ADDITIONAL_FIELD_TYPES_PROPERTY_NAME = "additionalFieldTypes";
    private static final String ADDITIONAL_PARENTS_PROPERTY_NAME = "additionalParents";
    private static final String LINK_ROLES_PROPERTY_NAME = "linkRoles";
    private static final String LINKED_SPEC_ITEMS_PROPERTY_NAME = "linkedSpecItems";
    private static final String TYPE_INFO_PROPERTY_NAME = "typeInfo";
    @JsonProperty(value="additionalAssignees")
    private final List<String> additionalAssignees;
    @JsonProperty(value="additionalFieldTypes")
    private final List<String> additionalFieldTypes;
    @JsonProperty(value="additionalParents")
    private final List<TeamscaleIssueId> additionalParents;
    @JsonProperty(value="linkRoles")
    private final List<String> linkRoles;
    @JsonProperty(value="linkedSpecItems")
    private final List<List<TeamscaleIssueId>> linkedSpecItems;
    @JsonProperty(value="typeInfo")
    private @Nullable TeamscaleIssueTypeInfo typeInfo;

    protected SpecItem(TeamscaleIssueId id, long created, String assignee, String subject) {
        super(id, created, subject, assignee);
        this.additionalAssignees = new ArrayList<String>();
        this.additionalFieldTypes = new ArrayList<String>();
        this.linkRoles = new ArrayList<String>();
        this.linkedSpecItems = new ArrayList<List<TeamscaleIssueId>>();
        this.additionalParents = new ArrayList<TeamscaleIssueId>();
    }

    private SpecItem(TeamscaleIssueId id, long created, List<String> additionalFieldNames, List<String> additionalFieldValues, List<String> additionalFieldTypes, String url, String firstParent, List<String> additionalParents) {
        super(id, null, null, null, null, created, 0L, null, false, url, additionalFieldNames, additionalFieldValues, firstParent);
        this.additionalAssignees = new ArrayList<String>();
        this.additionalFieldTypes = additionalFieldTypes;
        this.linkRoles = new ArrayList<String>();
        this.linkedSpecItems = new ArrayList<List<TeamscaleIssueId>>();
        this.additionalParents = additionalParents.stream().map(String::trim).map(id::withExternalId).collect(Collectors.toList());
    }

    @JsonCreator
    public SpecItem(@JsonProperty(value="id") TeamscaleIssueId id, @JsonProperty(value="subject") String subject, @JsonProperty(value="assignee") String assignee, @JsonProperty(value="author") String author, @JsonProperty(value="description") String description, @JsonProperty(value="created") long created, @JsonProperty(value="updated") long updated, @JsonProperty(value="status") String status, @JsonProperty(value="closed") boolean closed, @JsonProperty(value="url") String url, @JsonProperty(value="additionalFieldNames") List<String> additionalFieldNames, @JsonProperty(value="additionalFieldValues") List<String> additionalFieldValues, @JsonProperty(value="parentId") TeamscaleIssueId parentId, @JsonProperty(value="additionalAssignees") List<String> additionalAssignees, @JsonProperty(value="additionalFieldTypes") List<String> additionalFieldTypes, @JsonProperty(value="additionalParents") List<TeamscaleIssueId> additionalParents, @JsonProperty(value="linkRoles") List<String> linkRoles, @JsonProperty(value="linkedSpecItems") List<List<TeamscaleIssueId>> linkedSpecItems, @JsonProperty(value="type") String type, @JsonProperty(value="typeAbbreviation") String typeAbbreviation) {
        super(id, subject, assignee, author, description, created, updated, status, closed, url, additionalFieldNames, additionalFieldValues, parentId);
        this.additionalAssignees = new ArrayList<String>(additionalAssignees);
        this.additionalFieldTypes = additionalFieldTypes;
        CCSMAssert.isTrue((linkRoles.size() == linkedSpecItems.size() ? 1 : 0) != 0, (String)"Lists for link roles and linked requirements must have same length");
        this.linkRoles = linkRoles.stream().map(String::toLowerCase).collect(Collectors.toList());
        this.linkedSpecItems = new ArrayList<List<TeamscaleIssueId>>(linkedSpecItems);
        this.additionalParents = additionalParents;
        CCSMAssert.isNotNull((Object)id, (String)"A requirement must have a non-empty ID.");
        this.typeInfo = new TeamscaleIssueTypeInfo(type, typeAbbreviation);
    }

    public SpecItem(SpecItem specItem) {
        super(specItem);
        this.additionalAssignees = new ArrayList<String>(specItem.additionalAssignees);
        this.additionalFieldTypes = new ArrayList<String>(specItem.additionalFieldTypes);
        this.additionalParents = new ArrayList<TeamscaleIssueId>(specItem.additionalParents);
        this.linkRoles = new ArrayList<String>(specItem.linkRoles);
        this.linkedSpecItems = new ArrayList<List<TeamscaleIssueId>>(specItem.linkedSpecItems);
        this.typeInfo = specItem.typeInfo;
    }

    public SpecItem(TeamscaleIssue issue, List<String> additionalAssignees, List<String> additionalParents, List<String> linkRoles, List<List<String>> linkedSpecItems, String type, String typeAbbreviation) {
        super(issue);
        this.additionalAssignees = new ArrayList<String>(additionalAssignees);
        this.additionalFieldTypes = new ArrayList<String>();
        this.linkRoles = linkRoles.stream().map(String::toLowerCase).collect(Collectors.toList());
        this.linkedSpecItems = linkedSpecItems.stream().map(specItemIds -> specItemIds.stream().map(issue.getId()::withExternalId).collect(Collectors.toList())).collect(Collectors.toList());
        this.additionalParents = additionalParents.stream().map(String::trim).map(issue.getId()::withExternalId).collect(Collectors.toList());
        this.typeInfo = new TeamscaleIssueTypeInfo(type, typeAbbreviation);
    }

    public SpecItem(TeamscaleIssue issue, @Nullable TeamscaleIssueTypeInfo typeInfo) {
        super(issue);
        this.additionalAssignees = Collections.emptyList();
        this.additionalFieldTypes = Collections.emptyList();
        this.linkRoles = Collections.emptyList();
        this.linkedSpecItems = Collections.emptyList();
        this.additionalParents = Collections.emptyList();
        this.typeInfo = typeInfo;
    }

    public SpecItem copy() {
        return new SpecItem(this);
    }

    @Override
    public EWorkItemType getWorkItemType() {
        return EWorkItemType.SPEC_ITEM;
    }

    private void addAdditionalAssignees(List<String> additionalAssignees) {
        this.additionalAssignees.addAll(additionalAssignees);
    }

    public List<String> getAdditionalAssignees() {
        return Collections.unmodifiableList(this.additionalAssignees);
    }

    private void setAdditionalFieldType(String customFieldType) {
        this.additionalFieldTypes.add(customFieldType);
    }

    public UnmodifiableList<String> getAdditionalFieldTypes() {
        return CollectionUtils.asUnmodifiable(this.additionalFieldTypes);
    }

    @Override
    protected Map<String, ?> buildAdditionalFieldsMap() {
        if (this.additionalFieldTypes.isEmpty()) {
            return super.buildAdditionalFieldsMap();
        }
        UnmodifiableIterator additionalFieldNamesIter = this.getAdditionalFieldNames().iterator();
        UnmodifiableIterator additionalFieldValuesIter = this.getAdditionalFieldValues().iterator();
        Iterator<String> additionalFieldTypesIter = this.additionalFieldTypes.iterator();
        return CollectionUtils.zipToMap((Iterator)additionalFieldNamesIter, (Iterator)CollectionUtils.zipIterators((Iterator)additionalFieldValuesIter, additionalFieldTypesIter));
    }

    private void addLinkRoles(List<String> linkRoles) {
        linkRoles.forEach(role -> this.linkRoles.add(role.toLowerCase()));
    }

    public List<String> getLinkRoles() {
        return Collections.unmodifiableList(this.linkRoles);
    }

    public @Nullable TeamscaleIssueTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    public String getHumanReadableType() {
        return Optional.ofNullable(this.typeInfo).map(TeamscaleIssueTypeInfo::getType).orElseGet(() -> super.getHumanReadableType());
    }

    private void setTypeInfo(@Nullable TeamscaleIssueTypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    private void addLinkedSpecItems(List<List<String>> linkedSpecItems) {
        this.linkedSpecItems.addAll(linkedSpecItems.stream().map(itemIds -> itemIds.stream().map(itemId -> this.getId().withExternalId((String)itemId)).toList()).toList());
    }

    public List<List<TeamscaleIssueId>> getLinkedSpecItems() {
        return this.linkedSpecItems.stream().map(Collections::unmodifiableList).toList();
    }

    public List<TeamscaleIssueId> getLinkedSpecItems(String linkRole) {
        String normalizedLinkRole = linkRole.toLowerCase();
        for (int i = 0; i < this.linkRoles.size(); ++i) {
            if (!normalizedLinkRole.equals(this.linkRoles.get(i))) continue;
            return this.linkedSpecItems.get(i);
        }
        return Collections.emptyList();
    }

    public List<TeamscaleIssueId> getAdditionalParents() {
        return Collections.unmodifiableList(this.additionalParents);
    }

    @Override
    public Optional<String> getStringValueByPropertyName(String propertyName) {
        Optional<String> propertyValue = super.getStringValueByPropertyName(propertyName);
        if (propertyValue.isEmpty()) {
            return propertyValue;
        }
        return switch (propertyName) {
            case ADDITIONAL_ASSIGNEE_PROPERTY_NAME -> Optional.of(String.join((CharSequence)", ", this.getAdditionalAssignees()));
            case ADDITIONAL_FIELD_TYPES_PROPERTY_NAME -> Optional.of(String.join((CharSequence)", ", this.getAdditionalFieldTypes()));
            case ADDITIONAL_PARENTS_PROPERTY_NAME -> Optional.of(this.getAdditionalParents().stream().map(TeamscaleIssueId::toString).collect(Collectors.joining()));
            case LINK_ROLES_PROPERTY_NAME -> Optional.of(String.join((CharSequence)", ", this.getLinkRoles()));
            case LINKED_SPEC_ITEMS_PROPERTY_NAME -> Optional.of(this.getLinkedSpecItems().stream().flatMap(Collection::stream).map(TeamscaleIssueId::toString).collect(Collectors.joining()));
            case TYPE_INFO_PROPERTY_NAME -> Optional.ofNullable(this.getTypeInfo()).map(Object::toString).or(() -> Optional.of(""));
            default -> Optional.empty();
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpecItem specItem = (SpecItem)o;
        return Objects.equals(this.additionalAssignees, specItem.additionalAssignees) && Objects.equals(this.additionalParents, specItem.additionalParents) && Objects.equals(this.linkRoles, specItem.linkRoles) && Objects.equals(this.linkedSpecItems, specItem.linkedSpecItems) && Objects.equals(this.typeInfo, specItem.typeInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.additionalAssignees, this.additionalParents, this.linkRoles, this.linkedSpecItems, this.typeInfo);
    }

    @Override
    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    public static class SpecItemBuilder {
        private final SpecItem specItem;

        public SpecItemBuilder(TeamscaleIssueId id, long created, List<String> additionalFieldNames, List<String> additionalFieldValues, List<String> additionalFieldTypes, String url, List<String> parentIds) {
            CCSMAssert.isNotNull((Object)id, (String)"A specification item must have a non-empty ID.");
            String firstParent = "";
            if (!parentIds.isEmpty()) {
                firstParent = parentIds.getFirst();
            }
            ArrayList<String> additionalParents = new ArrayList<String>();
            if (parentIds.size() > 1) {
                additionalParents.addAll(parentIds.subList(1, parentIds.size()));
            }
            this.specItem = new SpecItem(id, created, additionalFieldNames, additionalFieldValues, additionalFieldTypes, url, firstParent, additionalParents);
        }

        @VisibleForTesting
        public SpecItemBuilder(TeamscaleIssueId id) {
            CCSMAssert.isNotNull((Object)id, (String)"A specification item must have a non-empty ID.");
            this.specItem = new SpecItem(id, 1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "", "", Collections.emptyList());
        }

        public SpecItemBuilder subject(String subject) {
            this.specItem.setSubject(subject);
            return this;
        }

        public SpecItemBuilder description(String description) {
            this.specItem.setDescription(description);
            return this;
        }

        public SpecItemBuilder author(String author) {
            this.specItem.setAuthor(author);
            return this;
        }

        public SpecItemBuilder assignee(String assignee) {
            this.specItem.setAssignee(assignee);
            return this;
        }

        public SpecItemBuilder additionalAssignees(List<String> assignees) {
            this.specItem.addAdditionalAssignees(assignees);
            return this;
        }

        public SpecItemBuilder status(String status) {
            this.specItem.setStatus(status);
            return this;
        }

        public SpecItemBuilder typeInfo(TeamscaleIssueTypeInfo typeInfo) {
            this.specItem.setTypeInfo(typeInfo);
            return this;
        }

        public SpecItemBuilder updated(long updated) {
            this.specItem.setUpdated(updated);
            return this;
        }

        public SpecItemBuilder customFields(List<ExternalToolIssueCustomField> customFields) {
            for (ExternalToolIssueCustomField customField : customFields) {
                this.specItem.setCustomField(customField.getName(), customField.getValue());
                this.specItem.setAdditionalFieldType(customField.getType());
            }
            return this;
        }

        public SpecItemBuilder linkedSpecItems(List<String> linkRoles, List<List<String>> linkedItems) {
            this.specItem.addLinkRoles(linkRoles);
            this.specItem.addLinkedSpecItems(linkedItems);
            return this;
        }

        public SpecItem build() {
            return this.specItem;
        }
    }
}

