/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.exceptions_hierarchy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.service.audit.exceptions_hierarchy.EExceptionSource;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExceptionsTree {
    @JsonProperty(value="name")
    private String name = "";
    @JsonProperty(value="parentId")
    private @Nullable String parentId = "";
    @JsonProperty(value="children")
    private Set<ExceptionsTree> children = new LinkedHashSet<ExceptionsTree>();
    @JsonProperty(value="countTransitiveNodes")
    private int countTransitiveNodes;
    @JsonIgnore
    private EExceptionSource exceptionSource;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public @Nullable String getParentId() {
        return this.parentId;
    }

    public void setParentId(@Nullable String parentId) {
        this.parentId = parentId;
    }

    public Set<ExceptionsTree> getChildren() {
        return this.children;
    }

    public void setExceptionSource(EExceptionSource exceptionSource) {
        this.exceptionSource = exceptionSource;
    }

    public void addChild(ExceptionsTree child) {
        this.children.add(child);
    }

    public boolean isParentExceptionUnknown() {
        return this.parentId == null;
    }

    public void setParentIdIsUnknown() {
        this.setParentId(null);
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public void pruneChildren() {
        this.children.forEach(ExceptionsTree::pruneChildren);
        this.children.removeIf(ExceptionsTree::shouldBePruned);
    }

    public boolean shouldBePruned() {
        return !this.hasChildren() && !this.exceptionSource.isKeepIfNoChildrenExist();
    }

    public void updateCountValues() {
        this.children.forEach(ExceptionsTree::updateCountValues);
        List<ExceptionsTree> filteredChildren = this.children.stream().filter(node -> node.children.isEmpty()).toList();
        this.countTransitiveNodes = filteredChildren.size() + this.children.stream().mapToInt(node -> node.countTransitiveNodes).sum();
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

