/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.service.findings.badge.FindingBadgeCreator;
import com.teamscale.service.framework.badge.BadgeCreatorBase;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.string.StringUtils;

public class CommitAlertsBadgeCreator
extends BadgeCreatorBase {
    private static final String COMMIT_ALERT_BADGE_TEMPLATE_NAME = "badge/commit-alert-badge-template.svg";
    private final Integer commitAlerts;

    public CommitAlertsBadgeCreator(Integer commitAlerts) {
        this.commitAlerts = commitAlerts;
    }

    public String createBadge() {
        return this.createBadge(COMMIT_ALERT_BADGE_TEMPLATE_NAME, CommitAlertsBadgeCreator.getCommitAlertsBadgeValueMap(this.commitAlerts));
    }

    private static Map<String, String> getCommitAlertsBadgeValueMap(Integer commitAlerts) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        FindingBadgeCreator.ESvgTemplatePlaceholder.COMMIT_ALERTS.insertInto(replacements, StringUtils.format((Number)commitAlerts));
        int textWidth = CommitAlertsBadgeCreator.computeTextWidth((String)StringUtils.format((Number)commitAlerts));
        int imageWidth = CommitAlertsBadgeCreator.formatCommitAlertsBadge(textWidth, replacements);
        FindingBadgeCreator.ESvgTemplatePlaceholder.SVG_RECT_WIDTH.insertInto(replacements, String.valueOf(imageWidth));
        return replacements;
    }

    private static int formatCommitAlertsBadge(int textWidth, Map<String, String> replacements) {
        FindingBadgeCreator.ESvgTemplatePlaceholder.SVG_ALERT_ICON_WIDTH.insertInto(replacements, String.valueOf(15));
        int iconXPosition = 8;
        FindingBadgeCreator.ESvgTemplatePlaceholder.SVG_ALERT_ICON_X.insertInto(replacements, String.valueOf(iconXPosition));
        int rectangleWidth = 15 + textWidth + 20;
        FindingBadgeCreator.ESvgTemplatePlaceholder.SVG_ALERT_RECT_PATH_D.insertInto(replacements, CommitAlertsBadgeCreator.svgRectanglePath((int)0, (int)rectangleWidth));
        int textXPosition = iconXPosition + 15 + 4;
        FindingBadgeCreator.ESvgTemplatePlaceholder.SVG_ALERT_TEXT_X.insertInto(replacements, String.valueOf(textXPosition));
        return rectangleWidth;
    }
}

